/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import java.util.Collection;
import java.util.Hashtable;

public class CorbaOutboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements OutboundConnectionCache {
    protected Hashtable connectionCache = new Hashtable();

    public CorbaOutboundConnectionCacheImpl(ORB orb, ContactInfo contactInfo) {
        super(orb, contactInfo.getConnectionCacheType(), ((CorbaContactInfo)contactInfo).getMonitoringName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection get(ContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".get: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.dprintStatistics();
            return (Connection)this.connectionCache.get(contactInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ContactInfo contactInfo, Connection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + contactInfo + " " + ((Object)contactInfo).hashCode() + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.put(contactInfo, connection);
            connection.setConnectionCache(this);
            this.dprintStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            if (contactInfo != null) {
                this.connectionCache.remove(contactInfo);
            }
            this.dprintStatistics();
        }
    }

    public Collection values() {
        return this.connectionCache.values();
    }

    protected Object backingStore() {
        return this.connectionCache;
    }

    protected void registerWithMonitoring() {
        MonitoredObject thisMO;
        MonitoredObject outboundConnectionMO;
        MonitoredObject orbMO = this.orb.getMonitoringManager().getRootMonitoredObject();
        MonitoredObject connectionMO = orbMO.getChild("Connections");
        if (connectionMO == null) {
            connectionMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Connections", "Statistics on inbound/outbound connections");
            orbMO.addChild(connectionMO);
        }
        if ((outboundConnectionMO = connectionMO.getChild("Outbound")) == null) {
            outboundConnectionMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Outbound", "Statistics on outbound connections");
            connectionMO.addChild(outboundConnectionMO);
        }
        if ((thisMO = outboundConnectionMO.getChild(this.getMonitoringName())) == null) {
            thisMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.getMonitoringName(), "Connection statistics");
            outboundConnectionMO.addChild(thisMO);
        }
        LongMonitoredAttributeBase attribute = new LongMonitoredAttributeBase("NumberOfConnections", "The total number of connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfConnections());
            }
        };
        thisMO.addAttribute(attribute);
        attribute = new LongMonitoredAttributeBase("NumberOfIdleConnections", "The number of idle connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfIdleConnections());
            }
        };
        thisMO.addAttribute(attribute);
        attribute = new LongMonitoredAttributeBase("NumberOfBusyConnections", "The number of busy connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfBusyConnections());
            }
        };
        thisMO.addAttribute(attribute);
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaOutboundConnectionCacheImpl", msg);
    }
}

