/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PolicySpi;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import sun.security.jca.GetInstance;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public abstract class Policy {
    public static final PermissionCollection UNSUPPORTED_EMPTY_COLLECTION = new UnsupportedEmptyCollection();
    private static Policy policy;
    private static final Debug debug;
    private WeakHashMap<ProtectionDomain.Key, PermissionCollection> pdMapping;

    static boolean isSet() {
        return policy != null;
    }

    private static void checkPermission(String type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("createPolicy." + type));
        }
    }

    public static Policy getPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
        }
        return Policy.getPolicyNoCheck();
    }

    static synchronized Policy getPolicyNoCheck() {
        block5: {
            if (policy == null) {
                String policy_class = null;
                policy_class = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("policy.provider");
                    }
                });
                if (policy_class == null) {
                    policy_class = "sun.security.provider.PolicyFile";
                }
                try {
                    policy = (Policy)Class.forName(policy_class).newInstance();
                }
                catch (Exception e) {
                    policy = new PolicyFile();
                    final String pc = policy_class;
                    Policy p = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                        @Override
                        public Policy run() {
                            try {
                                ClassLoader extcl = null;
                                for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
                                    extcl = cl;
                                }
                                return extcl != null ? (Policy)Class.forName(pc, true, extcl).newInstance() : null;
                            }
                            catch (Exception e) {
                                if (debug != null) {
                                    debug.println("policy provider " + pc + " not available");
                                    e.printStackTrace();
                                }
                                return null;
                            }
                        }
                    });
                    if (p != null) {
                        policy = p;
                    }
                    if (debug == null) break block5;
                    debug.println("using sun.security.provider.PolicyFile");
                }
            }
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy p) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (p != null) {
            Policy.initPolicy(p);
        }
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            policy = p;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy p) {
        ProtectionDomain policyDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return p.getClass().getProtectionDomain();
            }
        });
        PermissionCollection policyPerms = null;
        Object object = p;
        synchronized (object) {
            if (p.pdMapping == null) {
                p.pdMapping = new WeakHashMap();
            }
        }
        if (policyDomain.getCodeSource() != null) {
            if (Policy.isSet()) {
                policyPerms = policy.getPermissions(policyDomain);
            }
            if (policyPerms == null) {
                policyPerms = new Permissions();
                policyPerms.add(SecurityConstants.ALL_PERMISSION);
            }
            object = p.pdMapping;
            synchronized (object) {
                p.pdMapping.put(policyDomain.key, policyPerms);
            }
        }
    }

    public static Policy getInstance(String type, Parameters params) throws NoSuchAlgorithmException {
        Policy.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, type, params);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Policy.handleException(nsae);
        }
    }

    public static Policy getInstance(String type, Parameters params, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, type, (Object)params, provider);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Policy.handleException(nsae);
        }
    }

    public static Policy getInstance(String type, Parameters params, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(type);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, type, (Object)params, provider);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, type, params);
        }
        catch (NoSuchAlgorithmException nsae) {
            return Policy.handleException(nsae);
        }
    }

    private static Policy handleException(NoSuchAlgorithmException nsae) throws NoSuchAlgorithmException {
        Throwable cause = nsae.getCause();
        if (cause instanceof IllegalArgumentException) {
            throw (IllegalArgumentException)cause;
        }
        throw nsae;
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        return UNSUPPORTED_EMPTY_COLLECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = null;
        if (domain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap<ProtectionDomain.Key, PermissionCollection> weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            pc = this.pdMapping.get(domain.key);
        }
        if (pc != null) {
            Permissions perms = new Permissions();
            PermissionCollection permissionCollection = pc;
            synchronized (permissionCollection) {
                Enumeration<Permission> e = pc.elements();
                while (e.hasMoreElements()) {
                    perms.add(e.nextElement());
                }
            }
            return perms;
        }
        pc = this.getPermissions(domain.getCodeSource());
        if (pc == null || pc == UNSUPPORTED_EMPTY_COLLECTION) {
            pc = new Permissions();
        }
        this.addStaticPerms(pc, domain.getPermissions());
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticPerms(PermissionCollection perms, PermissionCollection statics) {
        if (statics != null) {
            PermissionCollection permissionCollection = statics;
            synchronized (permissionCollection) {
                Enumeration<Permission> e = statics.elements();
                while (e.hasMoreElements()) {
                    perms.add(e.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap<ProtectionDomain.Key, PermissionCollection> weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            pc = this.pdMapping.get(domain.key);
        }
        if (pc != null) {
            return pc.implies(permission);
        }
        pc = this.getPermissions(domain);
        if (pc == null) {
            return false;
        }
        weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            this.pdMapping.put(domain.key, pc);
        }
        return pc.implies(permission);
    }

    public void refresh() {
    }

    static {
        debug = Debug.getInstance("policy");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnsupportedEmptyCollection
    extends PermissionCollection {
        private Permissions perms = new Permissions();

        public UnsupportedEmptyCollection() {
            this.perms.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            this.perms.add(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            return this.perms.implies(permission);
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.perms.elements();
        }
    }

    public static interface Parameters {
    }

    private static class PolicyDelegate
    extends Policy {
        private PolicySpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private PolicyDelegate(PolicySpi spi, Provider p, String type, Parameters params) {
            this.spi = spi;
            this.p = p;
            this.type = type;
            this.params = params;
        }

        public String getType() {
            return this.type;
        }

        public Parameters getParameters() {
            return this.params;
        }

        public Provider getProvider() {
            return this.p;
        }

        public PermissionCollection getPermissions(CodeSource codesource) {
            return this.spi.engineGetPermissions(codesource);
        }

        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.spi.engineGetPermissions(domain);
        }

        public boolean implies(ProtectionDomain domain, Permission perm) {
            return this.spi.engineImplies(domain, perm);
        }

        public void refresh() {
            this.spi.engineRefresh();
        }
    }
}

