/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import sun.net.DefaultProgressMeteringPolicy;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.net.ProgressMeteringPolicy;
import sun.net.ProgressSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressMonitor {
    private static ProgressMeteringPolicy meteringPolicy = new DefaultProgressMeteringPolicy();
    private static ProgressMonitor pm = new ProgressMonitor();
    private ArrayList<ProgressSource> progressSourceList = new ArrayList();
    private ArrayList<ProgressListener> progressListenerList = new ArrayList();

    public static synchronized ProgressMonitor getDefault() {
        return pm;
    }

    public static synchronized void setDefault(ProgressMonitor m) {
        if (m != null) {
            pm = m;
        }
    }

    public static synchronized void setMeteringPolicy(ProgressMeteringPolicy policy) {
        if (policy != null) {
            meteringPolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProgressSource> getProgressSources() {
        ArrayList<ProgressSource> snapshot = new ArrayList<ProgressSource>();
        try {
            ArrayList<ProgressSource> arrayList = this.progressSourceList;
            synchronized (arrayList) {
                for (ProgressSource pi : this.progressSourceList) {
                    snapshot.add((ProgressSource)pi.clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return snapshot;
    }

    public synchronized int getProgressUpdateThreshold() {
        return meteringPolicy.getProgressUpdateThreshold();
    }

    public boolean shouldMeterInput(URL url, String method) {
        return meteringPolicy.shouldMeterInput(url, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSource(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (this.progressSourceList.contains(pi)) {
                return;
            }
            this.progressSourceList.add(pi);
        }
        if (this.progressListenerList.size() > 0) {
            ArrayList<ProgressListener> listeners = new ArrayList<ProgressListener>();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> iter = this.progressListenerList.iterator();
                while (iter.hasNext()) {
                    listeners.add(iter.next());
                }
            }
            for (ProgressListener pl : listeners) {
                ProgressEvent pe = new ProgressEvent(pi, pi.getURL(), pi.getMethod(), pi.getContentType(), pi.getState(), pi.getProgress(), pi.getExpected());
                pl.progressStart(pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSource(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(pi)) {
                return;
            }
            pi.close();
            this.progressSourceList.remove(pi);
        }
        if (this.progressListenerList.size() > 0) {
            ArrayList<ProgressListener> listeners = new ArrayList<ProgressListener>();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> iter = this.progressListenerList.iterator();
                while (iter.hasNext()) {
                    listeners.add(iter.next());
                }
            }
            for (ProgressListener pl : listeners) {
                ProgressEvent pe = new ProgressEvent(pi, pi.getURL(), pi.getMethod(), pi.getContentType(), pi.getState(), pi.getProgress(), pi.getExpected());
                pl.progressFinish(pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(ProgressSource pi) {
        ArrayList<ProgressSource> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(pi)) {
                return;
            }
        }
        if (this.progressListenerList.size() > 0) {
            ArrayList<ProgressListener> listeners = new ArrayList<ProgressListener>();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> iter = this.progressListenerList.iterator();
                while (iter.hasNext()) {
                    listeners.add(iter.next());
                }
            }
            for (ProgressListener pl : listeners) {
                ProgressEvent pe = new ProgressEvent(pi, pi.getURL(), pi.getMethod(), pi.getContentType(), pi.getState(), pi.getProgress(), pi.getExpected());
                pl.progressUpdate(pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener l) {
        ArrayList<ProgressListener> arrayList = this.progressListenerList;
        synchronized (arrayList) {
            this.progressListenerList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener l) {
        ArrayList<ProgressListener> arrayList = this.progressListenerList;
        synchronized (arrayList) {
            this.progressListenerList.remove(l);
        }
    }
}

