/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;
import sun.swing.plaf.synth.SynthUI;

class SynthToolBarUI
extends BasicToolBarUI
implements PropertyChangeListener,
SynthUI {
    protected Icon handleIcon = null;
    protected Rectangle contentRect = new Rectangle();
    private SynthStyle style;
    private SynthStyle contentStyle;
    private SynthStyle dragWindowStyle;

    SynthToolBarUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthToolBarUI();
    }

    protected void installDefaults() {
        this.toolBar.setLayout(this.createLayout());
        this.updateStyle(this.toolBar);
    }

    protected void installListeners() {
        super.installListeners();
        this.toolBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removePropertyChangeListener(this);
    }

    private void updateStyle(JToolBar c) {
        SynthContext context = this.getContext((JComponent)c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            this.handleIcon = this.style.getIcon(context, "ToolBar.handleIcon");
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        context = this.getContext(c, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.toolBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        this.handleIcon = null;
        context = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle.uninstallDefaults(context);
        context.dispose();
        this.contentStyle = null;
        context = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle.uninstallDefaults(context);
        context.dispose();
        this.dragWindowStyle = null;
        this.toolBar.setLayout(null);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected LayoutManager createLayout() {
        return new SynthToolBarLayoutManager();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        return SynthContext.getContext(SynthContext.class, c, region, this.dragWindowStyle, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private int getComponentState(JComponent c, Region region) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintToolBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.toolBar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintToolBarBorder(context, g, x, y, w, h, this.toolBar.getOrientation());
    }

    protected void setBorderToNonRollover(Component c) {
    }

    protected void setBorderToRollover(Component c) {
    }

    protected void setBorderToNormal(Component c) {
    }

    protected void paint(SynthContext context, Graphics g) {
        if (this.handleIcon != null && this.toolBar.isFloatable()) {
            int startX = this.toolBar.getComponentOrientation().isLeftToRight() ? 0 : this.toolBar.getWidth() - SynthIcon.getIconWidth(this.handleIcon, context);
            SynthIcon.paintIcon(this.handleIcon, context, g, startX, 0, SynthIcon.getIconWidth(this.handleIcon, context), SynthIcon.getIconHeight(this.handleIcon, context));
        }
        SynthContext subcontext = this.getContext((JComponent)this.toolBar, Region.TOOL_BAR_CONTENT);
        this.paintContent(subcontext, g, this.contentRect);
        subcontext.dispose();
    }

    public void paintContent(SynthContext context, Graphics g, Rectangle bounds) {
        SynthLookAndFeel.updateSubregion(context, g, bounds);
        context.getPainter().paintToolBarContentBackground(context, g, bounds.x, bounds.y, bounds.width, bounds.height, this.toolBar.getOrientation());
        context.getPainter().paintToolBarContentBorder(context, g, bounds.x, bounds.y, bounds.width, bounds.height, this.toolBar.getOrientation());
    }

    protected void paintDragWindow(Graphics g) {
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        SynthContext context = this.getContext((JComponent)this.toolBar, Region.TOOL_BAR_DRAG_WINDOW);
        SynthLookAndFeel.updateSubregion(context, g, new Rectangle(0, 0, w, h));
        context.getPainter().paintToolBarDragWindowBackground(context, g, 0, 0, w, h, this.dragWindow.getOrientation());
        context.getPainter().paintToolBarDragWindowBorder(context, g, 0, 0, w, h, this.dragWindow.getOrientation());
        context.dispose();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JToolBar)e.getSource());
        }
    }

    class SynthToolBarLayoutManager
    implements LayoutManager {
        SynthToolBarLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            Dimension dim = new Dimension();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            if (tb.getOrientation() == 0) {
                dim.width = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Dimension compDim = tb.getComponent(i).getMinimumSize();
                    dim.width += compDim.width;
                    dim.height = Math.max(dim.height, compDim.height);
                }
            } else {
                dim.height = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Dimension compDim = tb.getComponent(i).getMinimumSize();
                    dim.width = Math.max(dim.width, compDim.width);
                    dim.height += compDim.height;
                }
            }
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            context.dispose();
            return dim;
        }

        public Dimension preferredLayoutSize(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            Dimension dim = new Dimension();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            if (tb.getOrientation() == 0) {
                dim.width = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Dimension compDim = tb.getComponent(i).getPreferredSize();
                    dim.width += compDim.width;
                    dim.height = Math.max(dim.height, compDim.height);
                }
            } else {
                dim.height = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    Dimension compDim = tb.getComponent(i).getPreferredSize();
                    dim.width = Math.max(dim.width, compDim.width);
                    dim.height += compDim.height;
                }
            }
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            context.dispose();
            return dim;
        }

        public void layoutContainer(Container parent) {
            JToolBar tb = (JToolBar)parent;
            Insets insets = tb.getInsets();
            boolean ltr = tb.getComponentOrientation().isLeftToRight();
            SynthContext context = SynthToolBarUI.this.getContext(tb);
            if (tb.getOrientation() == 0) {
                int handleWidth = tb.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, context) : 0;
                SynthToolBarUI.this.contentRect.x = ltr ? handleWidth : 0;
                SynthToolBarUI.this.contentRect.y = 0;
                SynthToolBarUI.this.contentRect.width = tb.getWidth() - handleWidth;
                SynthToolBarUI.this.contentRect.height = tb.getHeight();
                int x = ltr ? handleWidth + insets.left : tb.getWidth() - handleWidth - insets.right;
                int baseY = insets.top;
                int baseH = tb.getHeight() - insets.top - insets.bottom;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    int h;
                    int y;
                    Component c = tb.getComponent(i);
                    Dimension d = c.getPreferredSize();
                    if (d.height >= baseH || c instanceof JSeparator) {
                        y = baseY;
                        h = baseH;
                    } else {
                        y = baseY + baseH / 2 - d.height / 2;
                        h = d.height;
                    }
                    c.setBounds(ltr ? x : x - d.width, y, d.width, h);
                    x = ltr ? x + d.width : x - d.width;
                }
            } else {
                int handleHeight = tb.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, context) : 0;
                SynthToolBarUI.this.contentRect.x = 0;
                SynthToolBarUI.this.contentRect.y = handleHeight;
                SynthToolBarUI.this.contentRect.width = tb.getWidth();
                SynthToolBarUI.this.contentRect.height = tb.getHeight() - handleHeight;
                int baseX = insets.left;
                int baseW = tb.getWidth() - insets.left - insets.right;
                int y = handleHeight + insets.top;
                for (int i = 0; i < tb.getComponentCount(); ++i) {
                    int w;
                    int x;
                    Component c = tb.getComponent(i);
                    Dimension d = c.getPreferredSize();
                    if (d.width >= baseW || c instanceof JSeparator) {
                        x = baseX;
                        w = baseW;
                    } else {
                        x = baseX + baseW / 2 - d.width / 2;
                        w = d.width;
                    }
                    c.setBounds(x, y, w, d.height);
                    y += d.height;
                }
            }
            context.dispose();
        }
    }
}

