/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.Enumeration;
import java.util.Locale;
import javax.swing.UIDefaults;

class MultiUIDefaults
extends UIDefaults {
    private UIDefaults[] tables;

    public MultiUIDefaults(UIDefaults[] defaults) {
        this.tables = defaults;
    }

    public MultiUIDefaults() {
        this.tables = new UIDefaults[0];
    }

    public Object get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            Object object = value = table != null ? table.get(key) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Object get(Object key, Locale l) {
        Object value = super.get(key, l);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            Object object = value = table != null ? table.get(key, l) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public int size() {
        int n = super.size();
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            n += table != null ? table.size() : 0;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        Enumeration[] enums = new Enumeration[1 + this.tables.length];
        enums[0] = super.keys();
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            if (table == null) continue;
            enums[i + 1] = table.keys();
        }
        return new MultiUIDefaultsEnumerator(enums);
    }

    public Enumeration elements() {
        Enumeration[] enums = new Enumeration[1 + this.tables.length];
        enums[0] = super.elements();
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            if (table == null) continue;
            enums[i + 1] = table.elements();
        }
        return new MultiUIDefaultsEnumerator(enums);
    }

    protected void getUIError(String msg) {
        if (this.tables.length > 0) {
            this.tables[0].getUIError(msg);
        } else {
            super.getUIError(msg);
        }
    }

    public Object remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            value = table != null ? table.remove(key) : null;
            Object v0 = value;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            if (table == null) continue;
            table.clear();
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            buf.append(key + "=" + this.get(key) + ", ");
        }
        int length = buf.length();
        if (length > 1) {
            buf.delete(length - 2, length);
        }
        buf.append("}");
        return buf.toString();
    }

    private static class MultiUIDefaultsEnumerator
    implements Enumeration {
        Enumeration[] enums;
        int n = 0;

        MultiUIDefaultsEnumerator(Enumeration[] enums) {
            this.enums = enums;
        }

        public boolean hasMoreElements() {
            for (int i = this.n; i < this.enums.length; ++i) {
                Enumeration e = this.enums[i];
                if (e == null || !e.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            while (this.n < this.enums.length) {
                Enumeration e = this.enums[this.n];
                if (e != null && e.hasMoreElements()) {
                    return e.nextElement();
                }
                ++this.n;
            }
            return null;
        }
    }
}

