/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanAttributeInfo
extends MBeanAttributeInfo
implements DescriptorAccess {
    private static final long oldSerialVersionUID = 7098036920755973145L;
    private static final long newSerialVersionUID = 6181543027787327345L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("attrDescriptor", Descriptor.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("attrDescriptor", Descriptor.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor attrDescriptor = this.createDefaultDescriptor();
    private static final String currClass = "ModelMBeanAttributeInfo";

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description, getter, setter);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "ModelMBeanAttributeInfo(String,String,Method,Method)", "Entry", name);
        }
        this.attrDescriptor = this.createDefaultDescriptor();
    }

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter, Descriptor descriptor) throws IntrospectionException {
        super(name, description, getter, setter);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "ModelMBeanAttributeInfo(String,String,Method,Method,Descriptor)", "Entry", name);
        }
        if (descriptor == null) {
            this.attrDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(descriptor)) {
            this.attrDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanAttributeInfo constructor");
        }
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, type, description, isReadable, isWritable, isIs);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "ModelMBeanAttributeInfo(String,String,String,boolean,boolean,boolean)", "Entry", name);
        }
        this.attrDescriptor = this.createDefaultDescriptor();
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Descriptor descriptor) {
        super(name, type, description, isReadable, isWritable, isIs);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "ModelMBeanAttributeInfo(String,String,String,boolean,boolean,boolean,Descriptor)", "Entry", name);
        }
        if (descriptor == null) {
            this.attrDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(descriptor)) {
            this.attrDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanAttributeInfo constructor");
        }
    }

    public ModelMBeanAttributeInfo(ModelMBeanAttributeInfo inInfo) {
        super(inInfo.getName(), inInfo.getType(), inInfo.getDescription(), inInfo.isReadable(), inInfo.isWritable(), inInfo.isIs());
        Descriptor newDesc;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "ModelMBeanAttributeInfo(ModelMBeanAttributeInfo)", "Entry");
        }
        this.attrDescriptor = (newDesc = inInfo.getDescriptor()) != null && this.isValid(newDesc) ? newDesc : this.createDefaultDescriptor();
    }

    public Descriptor getDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "getDescriptor()", "Entry");
        }
        if (this.attrDescriptor == null) {
            this.attrDescriptor = this.createDefaultDescriptor();
        }
        return (Descriptor)this.attrDescriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "setDescriptor(Descriptor)", "Received null for new descriptor value, setting descriptor to default values");
            }
            this.attrDescriptor = this.createDefaultDescriptor();
        } else {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "setDescriptor(Descriptor)", "Executed for " + inDescriptor.toString());
            }
            if (this.isValid(inDescriptor)) {
                this.attrDescriptor = (Descriptor)inDescriptor.clone();
            } else {
                throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanAttributeInfo setDescriptor");
            }
        }
    }

    public Object clone() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "clone()", "Entry");
        }
        return new ModelMBeanAttributeInfo(this);
    }

    public String toString() {
        return "ModelMBeanAttributeInfo: " + this.getName() + " ; Description: " + this.getDescription() + " ; Types: " + this.getType() + " ; isReadable: " + this.isReadable() + " ; isWritable: " + this.isWritable() + " ; Descriptor: " + this.getDescriptor();
    }

    private Descriptor createDefaultDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "createDefaultDescriptor()", "Entry");
        }
        return new DescriptorSupport("descriptorType=attribute", "name=" + this.getName(), "displayName=" + this.getName());
    }

    private boolean isValid(Descriptor inDesc) {
        boolean results = true;
        String badField = "none";
        if (inDesc == null) {
            badField = "nullDescriptor";
            results = false;
        } else if (!inDesc.isValid()) {
            badField = "inValidDescriptor";
            results = false;
        } else if (!((String)inDesc.getFieldValue("name")).equalsIgnoreCase(this.getName())) {
            badField = "name";
            results = false;
        } else if (!((String)inDesc.getFieldValue("descriptorType")).equalsIgnoreCase("attribute")) {
            badField = "desriptorType";
            results = false;
        } else if (inDesc.getFieldValue("displayName") == null) {
            inDesc.setField("displayName", this.getName());
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanAttributeInfo.class.getName(), "isValid()", "Returning " + results + " : Invalid field is " + badField);
        }
        return results;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("attrDescriptor", this.attrDescriptor);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 7098036920755973145L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 6181543027787327345L;
        }
    }
}

