// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_FMMM_FILE_SELECTION_H
#define _HILDON_FMMM_FILE_SELECTION_H


#include <glibmm.h>

/*
 * Copyright 2006-2007 The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/filefilter.h>
#include <hildon-fmmm/file-system-model.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFileSelection HildonFileSelection;
typedef struct _HildonFileSelectionClass HildonFileSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FileSelection_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildon_fmmmEnums Enums and Flags */

/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionMode
{
  FILE_SELECTION_MODE_LIST,
  FILE_SELECTION_MODE_THUMBNAILS
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::FileSelectionMode> : public Glib::Value_Enum<Hildon::FileSelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionPane
{
  FILE_SELECTION_PANE_NAVIGATION,
  FILE_SELECTION_PANE_CONTENT
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::FileSelectionPane> : public Glib::Value_Enum<Hildon::FileSelectionPane>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildon_fmmmEnums
 */
enum FileSelectionSortKey
{
  FILE_SELECTION_SORT_NAME,
  FILE_SELECTION_SORT_TYPE,
  FILE_SELECTION_SORT_MODIFIED,
  FILE_SELECTION_SORT_SIZE
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::FileSelectionSortKey> : public Glib::Value_Enum<Hildon::FileSelectionSortKey>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildon_fmmmEnums
 * @par Bitwise operators:
 * <tt>%FileSelectionVisibleColumns operator|(FileSelectionVisibleColumns, FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns operator&(FileSelectionVisibleColumns, FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns operator^(FileSelectionVisibleColumns, FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns operator~(FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns& operator|=(FileSelectionVisibleColumns&, FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns& operator&=(FileSelectionVisibleColumns&, FileSelectionVisibleColumns)</tt><br>
 * <tt>%FileSelectionVisibleColumns& operator^=(FileSelectionVisibleColumns&, FileSelectionVisibleColumns)</tt><br>
 */
enum FileSelectionVisibleColumns
{
  FILE_SELECTION_SHOW_NAME = 1,
  FILE_SELECTION_SHOW_MODIFIED = 2,
  FILE_SELECTION_SHOW_SIZE = 4,
  FILE_SELECTION_SHOW_ALL = 7
};

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns operator|(FileSelectionVisibleColumns lhs, FileSelectionVisibleColumns rhs)
  { return static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns operator&(FileSelectionVisibleColumns lhs, FileSelectionVisibleColumns rhs)
  { return static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns operator^(FileSelectionVisibleColumns lhs, FileSelectionVisibleColumns rhs)
  { return static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns operator~(FileSelectionVisibleColumns flags)
  { return static_cast<FileSelectionVisibleColumns>(~static_cast<unsigned>(flags)); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns& operator|=(FileSelectionVisibleColumns& lhs, FileSelectionVisibleColumns rhs)
  { return (lhs = static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns& operator&=(FileSelectionVisibleColumns& lhs, FileSelectionVisibleColumns rhs)
  { return (lhs = static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup hildon_fmmmEnums */
inline FileSelectionVisibleColumns& operator^=(FileSelectionVisibleColumns& lhs, FileSelectionVisibleColumns rhs)
  { return (lhs = static_cast<FileSelectionVisibleColumns>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::FileSelectionVisibleColumns> : public Glib::Value_Flags<Hildon::FileSelectionVisibleColumns>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


//TODO: Is this really public API?

/** @defgroup HildonWidgets Widgets
 */

/** A file tree widget.
 *
 * @ingroup HildonWidgets
 * @ingroup HildonFileSystem
 */

class FileSelection : public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileSelection CppObjectType;
  typedef FileSelection_Class CppClassType;
  typedef HildonFileSelection BaseObjectType;
  typedef HildonFileSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileSelection_Class;
  static CppClassType fileselection_class_;

  // noncopyable
  FileSelection(const FileSelection&);
  FileSelection& operator=(const FileSelection&);

protected:
  explicit FileSelection(const Glib::ConstructParams& construct_params);
  explicit FileSelection(HildonFileSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFileSelection*       gobj()       { return reinterpret_cast<HildonFileSelection*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFileSelection* gobj() const { return reinterpret_cast<HildonFileSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_current_folder_changed();
  virtual void on_file_activated();
  virtual void on_selection_changed();
  virtual void on_navigation_pane_context_menu();
  virtual void on_content_pane_context_menu();
  virtual void on_uris_dropped(const Glib::ustring& destination, const Glib::SListHandle<Glib::ustring>& sources);
  virtual void on_location_insensitive(const Gtk::TreeModel::iterator& iter);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

   
public:
  explicit FileSelection(const Glib::RefPtr<FileSystemModel>& model);


  /** Swithces file selection between list and thumbnail modes. Note that
   * this function works only after widget is shown because of Gtk::Notebook
   * implementation.
   * @param mode New mode for current folder.
   */
  void set_mode(FileSelectionMode mode);
  
  /** Gets Current view mode for file selection widget. If widget is not
   * shown this will return an invalid mode (-1). 
   * This is because of Gtk::Notebook implementation.
   * @return Current view mode.
   */
  FileSelectionMode get_mode() const;
  
  /** Changes sort settings for views. Key only affects content page,
   * navigation pane is always sorted by name.
   * @param key New sort key.
   * @param order New sort order.
   */
  void set_sort_key(FileSelectionSortKey key, Gtk::SortType order);

  
  /** Currently active sort settings are stored to user provided pointers.
   * @param key A place to store sort key.
   * @param order A place to store sort order.
   */

  FileSelectionSortKey get_sort_key() const;
  Gtk::SortType get_sort_order() const;

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_current_folder_uri(const std::string& folder);
#else
  bool set_current_folder_uri(const std::string& folder, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  Glib::ustring get_current_folder_uri() const;

  
  void set_current_folder_iter(const Gtk::TreeModel::iterator& iter);

  /** Retrieves an iterator to match the currently selected item in the 
   * navigation pane. Internally this gets the selection from the
   * tree and then the current iterator from the selection and converts
   * the result accordingly.
   *
   * @result A valid iterator, if the given iterator is set, or an invalid iterator if none is set.
   */
  Gtk::TreeModel::iterator get_current_folder_iter();
  

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool select_uri(const std::string& uri);
#else
  bool select_uri(const std::string& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  void unselect_uri(const std::string& uri);

  
  /** Selects all files from the content pane. Multiple selection must be
   * enabled before calling this.
   */
  void select_all();
  
  /** Clears current selection from content pane.
   */
  void unselect_all();
  
  /** Otherwise similar to #unselect_all,
   * but keeps the node with cursor selected. Thus,
   * this function don't have any efect in single selection mode.
   */
  void clear_multi_selection();


  Glib::SListHandle<Glib::ustring> get_selected_uris() const;

  
  /** If multiple selection is enabled, checkboxes will appear to the last
   * item to the content pane. Multiple selection must be enabled if one
   * wants to call #select_all.
   * @param select_multiple Either <tt>true</tt> or <tt>false</tt>.
   */
  void set_select_multiple(bool select_multiple = true);
  
  /** Gets state of multiple selection.
   * @return <tt>true</tt> If multiple selection is currently enabled.
   */
  bool get_select_multiple() const;

  
  void set_column_headers_visible(bool visible = true);
  
  bool get_column_headers_visible() const;

  
  /** Only the files matching the filter will be displayed in content pane.
   * Use <tt>0</tt> to remove filtering.
   * @param filter A new Gtk::FileFilter.
   */
  void set_filter(const Gtk::FileFilter& filter);
  
  /** Get currently active filter set by #set_filter.
   * Can be <tt>0</tt> if no filter is set.
   * @return A Gtk::FileFilter or <tt>0</tt>.
   */
  Gtk::FileFilter* get_filter();
  
  /** Get currently active filter set by #set_filter.
   * Can be <tt>0</tt> if no filter is set.
   * @return A Gtk::FileFilter or <tt>0</tt>.
   */
  const Gtk::FileFilter* get_filter() const;

  
  /** Appends currently selected paths to set of dimmed paths.
   * Note that dimmed paths cannot be selected, so selection
   * no longer contains the same paths after this function.
   */
  void dim_current_selection();
  
  /** Undims all from model that are dimmed by code. Simply calls
   * Hildon::FileSystemModel::reset_available for underlying model.
   */
  void undim_all();

  
  /** Gets the pane that either has active focus or 
   * (in case of no pane has it) last time had it.
   * @return Currently active pane.
   */
  FileSelectionPane get_active_pane() const;

  
  void hide_navigation_pane();
  
  /** Hides the content pane. This is used in certain file management dialogs.
   */
  void hide_content_pane();
  
  /** Shows the content pane. This is used in certain file management dialogs. 
   * The content pane is shown by default. Calling this is needed only if
   * you have hidden
   */
  void show_content_pane();

  
  void move_cursor_to_uri(const Glib::ustring& uri);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%current_folder_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_current_folder_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%file_activated()</tt>
   */

  Glib::SignalProxy0< void > signal_file_activated();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%folder_activated()</tt>
   */

  Glib::SignalProxy0< void > signal_folder_activated();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%selection_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_selection_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%navigation_pane_context_menu()</tt>
   */

  Glib::SignalProxy0< void > signal_navigation_pane_context_menu();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%content_pane_context_menu()</tt>
   */

  Glib::SignalProxy0< void > signal_content_pane_context_menu();


  /**
   * @par Prototype:
   * <tt>void on_my_%uris_dropped(const Glib::ustring& destination, const Glib::SListHandle<Glib::ustring>& sources)</tt>
   */

  Glib::SignalProxy2< void,const Glib::ustring&,const Glib::SListHandle<Glib::ustring>& > signal_uris_dropped();


  /**
   * @par Prototype:
   * <tt>void on_my_%location_insensitive(const Gtk::TreeModel::iterator& iter)</tt>
   */

  Glib::SignalProxy1< void,const Gtk::TreeModel::iterator& > signal_location_insensitive();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set the HildonFileSystemModel to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileSystemModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Ask file selection to enable drag'n'drop support.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_drag_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_empty_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** String to use when selected folder is empty.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_empty_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Defines the columns shown on content pane.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_visible_columns() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


   #ifdef GLIBMM_PROPERTIES_ENABLED
/** Safe folder to use as fallback in various operations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<std::string> property_safe_folder() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Safe folder to use as fallback in various operations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_safe_folder() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Which pane (navigation or content) has (or last time had) active focus.This in formation can be used to find which pane should be used to query selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_active_pane() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Which pane (navigation or content) has (or last time had) active focus.This in formation can be used to find which pane should be used to query selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_active_pane() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Show hidden files in file selector widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_hidden() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Show hidden files in file selector widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_hidden() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not all the displayed items should have a local file path.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_local_only() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not all the displayed items should have a local file path.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_local_only() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to show UPNP devices.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_upnp() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to show UPNP devices.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_upnp() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The position of the division between the both panes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_pane_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The position of the division between the both panes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_pane_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not dragging is ongoing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_currently_dragging() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** show the files in the content pane if this property is TRUE (TRUE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_files() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** show the files in the content pane if this property is TRUE (TRUE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_files() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** create GtkTreeView in Edit Mode if this property is TRUE (FALSE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_edit_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Hide the left navigation pane if this property is TRUE (FALSE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_hide_navi() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** show folders in the content pane if this property is TRUE (TRUE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_folders() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** show folders in the content pane if this property is TRUE (TRUE by default).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_folders() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::FileSelection
   */
  Hildon::FileSelection* wrap(HildonFileSelection* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_FMMM_FILE_SELECTION_H */

