import unittest
from org.maemo.hermes.engine.syncjob import SyncJob

class FakeContact():
    def __init__(self):
        pass
    
class FakeService():
    def __init__(self):
        self.contacts_preprocessed = []
        self.contacts_processed = []
    def get_name(self):
        return "fake service"
    def pre_process_contact(self, contact):
        self.contacts_preprocessed.append(contact)
    def process_friends(self):
        pass
    def process_contact(self, contact):
        self.contacts_processed.append(contact)
     
    
class TestSyncJob(unittest.TestCase):
    
    def setUp(self):
        self.service = FakeService() 
        self.services = [self.service]
        self.contact = FakeContact()
        self.contacts = [self.contact]
        self.testee = SyncJob(self.services, self.contacts)
        
    def test_main_flow(self):
        self.testee.run()
        assert self.contact in self.service.contacts_preprocessed
        assert self.contact in self.service.contacts_processed
    
if __name__ == '__main__':
    unittest.main()
