import gnome.gconf
import org.maemo.hermes.engine.provider
import org.maemo.hermes.engine.gravatar.service

class Provider(org.maemo.hermes.engine.provider.Provider):
    """Gravatar provider for Hermes. 

       Copyright (c) Fredrik Wendt <fredrik@wendt.se> 2010.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self):
        self._gconf = gnome.gconf.client_get_default()

        self._api_email = self._gconf.get_string('/apps/maemo/hermes/gravatar_email')
        self._api_key = self._gconf.get_string('/apps/maemo/hermes/gravatar_key')

        if self._api_key is None or self._api_email is None:
            raise Exception('No Gravatar application keys found. Installation error.')


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'Gravatar'
    
    
    # -----------------------------------------------------------------------
    def has_preferences(self):
        """Whether or not this provider has any preferences. If it does not,
           open_preferences must NOT be called; as the behaviour is undetermined."""
           
        return False

    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return the service backend"""

        return org.maemo.hermes.engine.gravatar.service.Service(self.get_id(), self._api_email, self._api_key)
