#include "filesystemmodel.h"

FileSystemModelWorker::FileSystemModelWorker(FileSystemModel *owner)
{
    currentDir = owner->currentDir;
    firstDetail = owner->firstDetail;
    secondDetail = owner->secondDetail;
}

void FileSystemModelWorker::FileSystemModelWorker::run()
{
    currentDir.refresh();
    QFileInfoList entries = currentDir.entryInfoList();
    foreach (QFileInfo entry, entries) {
        QStandardItem *item = new QStandardItem();

        item->setText(entry.fileName());
        item->setData(entry.absoluteFilePath(), FileSystemModel::PathRole);

        item->setData(FileSystemModel::detailString(entry, firstDetail), FileSystemModel::FirstDetailRole);
        item->setData(FileSystemModel::detailString(entry, secondDetail), FileSystemModel::SecondDetailRole);
        item->setData(entry.isSymLink(), FileSystemModel::SymLinkRole);
        item->setData(!entry.exists(), FileSystemModel::BrokenRole);

        emit itemReady(item);
    }
}
