#include "glatitude.h"

GoogleLatitude::GoogleLatitude(QObject *parent) :
        QObject(parent),
        user(""), pass(""), login_error(false),
        latitude(0), longitude(0), accuracy(0) {

    worker = new QNetworkAccessManager();
    connect(worker, SIGNAL(finished(QNetworkReply *)), this, SLOT(glat_reply(QNetworkReply *)));

    urllogin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview");
    urldologin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLoginAuth?service=friendview");
    urlupdate = QUrl::fromEncoded("http://maps.google.com/glm/mmap/mwmfr?hl=en");
}

void GoogleLatitude::set_login(QString u, QString p) {
    qDebug() << "GoogleLatitude: set_login";
    if ( !u.contains('@') ) u.append("@gmail.com");
    user = u;
    pass = p;
}

void GoogleLatitude::update(double la, double lo, double ac) {
    if (login_error) return;
    if (!la) return;
    if (!lo) return;
    if (!ac) return;

#if QT_VERSION >= QT_VERSION_CHECK(4, 7, 0)
    QNetworkConfigurationManager mgr;
    if (!mgr.isOnline()) {
        qDebug() << "GoogleLatitude: offline";
        return;
    }
#endif

    qDebug() << "GoogleLatitude: update";

    latitude = la;
    longitude = lo;
    accuracy = ac;

    worker->get(QNetworkRequest(urllogin));
}

void GoogleLatitude::reset() {
    qDebug() << "GoogleLatitude: reset";
    login_error = false;
    update(latitude, longitude, accuracy);
}

void GoogleLatitude::glat_reply(QNetworkReply *r) {
    if ( r->url() == urllogin ) {
        qDebug() << "GoogleLatitude: login";
        QString aidis = r->readAll();
        QRegExp regexp ("type=\"hidden\".*name=\"GALX\".*value=\"(.*)\"");
        regexp.setMinimal(1);
        regexp.indexIn(aidis, 1);
        QString googleGALX = regexp.capturedTexts().last();

        QByteArray datalogin;
        datalogin += "&service=friendview";
        datalogin += "&GALX=" + googleGALX;
        datalogin += "&Email=" + user;
        datalogin += "&Passwd=" + pass;
        worker->post(QNetworkRequest(urldologin), datalogin);
    } else if ( r->url() == urldologin ) {
        qDebug() << "GoogleLatitude: dologin";
        QByteArray datagps;
        datagps += "t=ul";
        datagps += "&lat=" + QString::number(latitude);
        datagps += "&lng=" + QString::number(longitude);
        datagps += "&accuracy=" + QString::number(accuracy);

        QNetworkRequest request(urlupdate);
        request.setRawHeader("X-ManualHeader", QString("true").toAscii() );
        worker->post(request, datagps);
    } else if ( r->url() == urlupdate ) {
        QString output = r->readAll();
        QRegExp regexp ("Authentication required");
        if (regexp.indexIn(output, 1) != -1) {
            qDebug() << "GoogleLatitude: update error auth";
            login_error = true;
            emit glat_error();
        } else {
            qDebug() << "GoogleLatitude: update ok";
            qDebug() << output;
            emit glat_ok();
        }
    } else {
        qDebug() << "GoogleLatitude Error url" << r->url();
        qDebug() << r->rawHeaderList();
        qDebug() << r->readAll();
    }
}
