// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_CANCELLABLE_H
#define _GIOMM_CANCELLABLE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GCancellable GCancellable;
typedef struct _GCancellableClass GCancellableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Cancellable_Class; } // namespace Gio
namespace Gio
{

/** Allows actions to be cancelled.
 * Cancellable is a thread-safe operation cancellation stack used throughout GIO to allow for cancellation of synchronous and asynchronous operations.
 *
 * @newin{2,16}
 */

class Cancellable : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Cancellable CppObjectType;
  typedef Cancellable_Class CppClassType;
  typedef GCancellable BaseObjectType;
  typedef GCancellableClass BaseClassType;

private:  friend class Cancellable_Class;
  static CppClassType cancellable_class_;

private:
  // noncopyable
  Cancellable(const Cancellable&);
  Cancellable& operator=(const Cancellable&);

protected:
  explicit Cancellable(const Glib::ConstructParams& construct_params);
  explicit Cancellable(GCancellable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Cancellable();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GCancellable*       gobj()       { return reinterpret_cast<GCancellable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GCancellable* gobj() const { return reinterpret_cast<GCancellable*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GCancellable* gobj_copy();

private:


protected:
  Cancellable();

public:
  
  static Glib::RefPtr<Cancellable> create();


  /** Checks if a cancellable job has been cancelled.
   * @return <tt>true</tt> if @a cancellable is cancelled, 
   * <tt>false</tt> if called with <tt>0</tt> or if item is not cancelled.
   */
  bool is_cancelled() const;

  
  //May return -1 if fds not supported, or on errors .
  
  /** Gets the file descriptor for a cancellable job. This can be used to
   * implement cancellable operations on Unix systems. The returned fd will
   * turn readable when @a cancellable is cancelled.
   * 
   * See also g_cancellable_make_pollfd().
   * @return A valid file descriptor. %-1 if the file descriptor 
   * is not supported, or on errors.
   */
  int get_fd() const;

  //This is safe to call from another thread.
  
  /** Will set @a cancellable to cancelled, and will emit the
   * Cancellable::cancelled signal. (However, see the warning about
   * race conditions in the documentation for that signal if you are
   * planning to connect to it.)
   * 
   * This function is thread-safe. In other words, you can safely call
   * it from a thread other than the one running the operation that was
   * passed the @a cancellable.
   * 
   * The convention within gio is that cancelling an asynchronous
   * operation causes it to complete asynchronously. That is, if you
   * cancel the operation from the same thread in which it is running,
   * then the operation's AsyncReadyCallback will not be invoked until
   * the application returns to the main loop.
   */
  void cancel();

  
  /** Gets the top cancellable from the stack.
   * @return A Cancellable from the top of the stack, or <tt>0</tt>
   * if the stack is empty.
   */
  static Glib::RefPtr<Cancellable> get_current();

  
  /** Pushes @a cancellable onto the cancellable stack. The current
   * cancllable can then be recieved using g_cancellable_get_current().
   * 
   * This is useful when implementing cancellable operations in
   * code that does not allow you to pass down the cancellable object.
   * 
   * This is typically called automatically by e.g. File operations,
   * so you rarely have to call this yourself.
   */
  void push_current();
  
  /** Pops @a cancellable off the cancellable stack (verifying that @a cancellable 
   * is on the top of the stack).
   */
  void pop_current();
  
  /** Resets @a cancellable to its uncancelled state.
   */
  void reset();

  // TODO: is this useful in the C++ API?
  //_WRAP_METHOD(void make_pollfd(PollFD* pollfd), g_cancellable_make_pollfd)

  
  /**
   * @par Prototype:
   * <tt>void on_my_%cancelled()</tt>
   */

  Glib::SignalProxy0< void > signal_cancelled();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_cancelled();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Cancellable
   */
  Glib::RefPtr<Gio::Cancellable> wrap(GCancellable* object, bool take_copy = false);
}


#endif /* _GIOMM_CANCELLABLE_H */

