#include "searchvenueswindow.h"
#include "ui_searchvenueswindow.h"
#include <QMaemo5InformationBox>
#include "addvenueform.h"

#include <QDebug>
#include <QListWidgetItem>

SearchVenuesWindow::SearchVenuesWindow(QWidget *parent) :
    QWidget(parent), ui(new Ui::SearchVenuesWindow)
{
    ui->setupUi(this);
    fsc = FoursquareComm::instance();
    ps = PositionSource::instance();
    ic = new ImageCache(this);

    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);
}

SearchVenuesWindow::~SearchVenuesWindow()
{
    delete ui;
}

void SearchVenuesWindow::on_pbSearch_clicked()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    if(!ps->isValidPosition())
    {
        QMaemo5InformationBox::information(this, "<p>Invalid GPS position.</p>", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    qDebug() << "Latitude " + QString::number(ps->gc.latitude());
    qDebug() << "Longitude " + QString::number(ps->gc.longitude());

    lastResult = fsc->searchVenues(ps->getLL(),QString(),ui->leQuery->text());

    parseAndShowResult();
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
}

void SearchVenuesWindow::on_pbNearby_clicked()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    if(!ps->isValidPosition())
    {
        QMaemo5InformationBox::information(this, "<p>Invalid GPS position.</p>", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    qDebug() << "Latitude " + QString::number(ps->gc.latitude());
    qDebug() << "Longitude " + QString::number(ps->gc.longitude());

    lastResult = fsc->searchVenues(ps->getLL());

    parseAndShowResult();
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
}

void SearchVenuesWindow::showDetailsForm(f_venue venue)
{
    vd = new VenueDetails(this);
    vd->setVenue(venue);
    vd->show();
}

void SearchVenuesWindow::parseAndShowResult()
{
    ui->twNearby->clear();

    for (int i = 0; i < lastResult.size(); ++i) {
        QTreeWidgetItem* item = new QTreeWidgetItem(ui->twNearby);
        item->setIcon(0,QIcon(ic->getImage(lastResult.at(i).icon)));
        item->setText(1,lastResult.at(i).name+"\n"+QString::number(lastResult.at(i).location.distance)+"m.");
        item->setText(2,lastResult.at(i).location.address+"\n"+lastResult.at(i).location.city);
    }
    QTreeWidgetItem* item = new QTreeWidgetItem(ui->twNearby);
    item->setTextAlignment(0,Qt::AlignCenter);
    //TODO add icon
    item->setText(0,"+");
    QFont font;
    font.setPointSize(item->font(0).pointSize()+8);
    font.setBold(true);
    item->setFont(0,font);
    item->setText(1,"Add venue");
    for(int i = 0; i< ui->twNearby->columnCount(); i++)
        ui->twNearby->resizeColumnToContents(i);
}

void SearchVenuesWindow::on_twNearby_clicked(QModelIndex index)
{
    if(index.row()==lastResult.size()) //last item, should be add venue
    {
        avf = new AddVenueForm(this);
        connect(avf,SIGNAL(venueAdded(f_venue)),this,SLOT(showDetailsForm(f_venue)));
        avf->show();
    }
    else
        showDetailsForm(lastResult.at(index.row()));
}
