import platforms
from utils import logging

import dbus


class SoundPipe(object):
    """
    Class for actually getting sound out of the FM radio.
    """

    def __init__(self):
    
        self.__use_speaker = False
        self.__speaker_volume = 50

        # set up speaker control
        try:
            bus = platforms.get_session_bus()
            obj = bus.get_object("com.nokia.osso_hp_ls_controller",
                                 "/com/nokia/osso_hp_ls_controller")
            self.__speaker = dbus.Interface(obj,
                                  "com.nokia.osso_hp_ls_controller.loudspeaker")
        except:
            logging.warning("cannot force loudspeaker")
            self.__speaker = None

        
    def on(self):

        pass


    def off(self):

        pass
        
        
    def use_speaker(self, v):

        if (not self.__speaker): return

        if (v):
            self.__use_speaker = True
            self.__speaker.force_loudspeaker_on()
            
        else:
            self.__use_speaker = False
            self.__speaker.force_loudspeaker_off()
            

    def set_speaker_volume(self, v):

        pass    

