import os

def _amixer(name, value):

    print "mixer", name, value
    os.system("amixer -Dhw:0 cset iface=MIXER,name='%s' %s >/dev/null" % (name, value))


def set_pga_capture(v):

    if (v):
        _amixer("PGA Capture Switch", "on")
    else:
        _amixer("PGA Capture Switch", "off")


def set_pga_line2(v):

    if (v):        
        _amixer("Left PGA Mixer Line2L Switch", "on")
        _amixer("Right PGA Mixer Line2R Switch", "on")
    else:
        _amixer("Left PGA Mixer Line2L Switch", "off")
        _amixer("Right PGA Mixer Line2R Switch", "off")


def set_pga_bypass(v):

    if (v):
        _amixer("Left PGA Bypass Mixer Line Swit", "on")
        _amixer("Left Line2 Bypass Mixer Line Sw", "on")
        _amixer("Right PGA Bypass Mixer Line Swi", "on")
        _amixer("Right Line2 Bypass Mixer Line S", "on")
        _amixer("Line PGA Bypass Playback Volume", "80,80")
    else:
        _amixer("Left PGA Bypass Mixer Line Swit", "off")
        _amixer("Left Line2 Bypass Mixer Line Sw", "off")
        _amixer("Right PGA Bypass Mixer Line Swi", "off")
        _amixer("Right Line2 Bypass Mixer Line S", "off")
        _amixer("Line PGA Bypass Playback Volume", "0")


def set_differential_input(v):

    if (v):
        _amixer("Left Line2L Mux", "differential")
        _amixer("Right Line2R Mux", "differential")
    else:
        _amixer("Left Line2L Mux", "single-ended")
        _amixer("Right Line2R Mux", "single-ended")


def set_microphone(v):

    if (v):
        print "Microphone ON"
        _amixer("Input Select", "'Digital Mic'")
        _amixer("Left PGA Mixer Line1L Switch", "on")
        _amixer("Right PGA Mixer Line1L Switch", "on")
        _amixer("Right PGA Mixer Line1R Switch", "on")
        _amixer("PGA Capture Volume", "40,40")
    else:
        print "Microphone OFF"
        _amixer("Input Select", "ADC")
        _amixer("Left PGA Mixer Line1L Switch", "off")
        _amixer("Right PGA Mixer Line1L Switch", "off")
        _amixer("Right PGA Mixer Line1R Switch", "off")
        _amixer("PGA Capture Volume", "0,0")


def set_speaker(v):

    if (v):
        _amixer("Jack Function", "Off")
        #_amixer("Line DAC Playback Switch", "off")
        #_amixer("Line DAC Playback Volume", "0,0")

        #_amixer("HPCOM DAC Playback Switch", "on")

        _amixer("Left DAC_L1 Mixer HP Switch", "on")
        #_amixer("Left DAC_L1 Mixer Line Switch", "off")
        _amixer("Right DAC_R1 Mixer HP Switch", "on")
        #_amixer("Right DAC_R1 Mixer Line Switch", "off")

        _amixer("HP DAC Playback Volume", "50,50")
        _amixer("Speaker Function", "1")
        
    else:
        _amixer("Jack Function", "Headset")

        #_amixer("Line DAC Playback Switch", "off")
        #_amixer("Line DAC Playback Volume", "0,0")

        #_amixer("HPCOM DAC Playback Switch", "on")

        _amixer("Left DAC_L1 Mixer HP Switch", "off")
        #_amixer("Left DAC_L1 Mixer Line Switch", "off")
        _amixer("Right DAC_R1 Mixer HP Switch", "off")
        #_amixer("Right DAC_R1 Mixer Line Switch", "off")

        """
        _amixer("Line DAC Playback Switch", "on")
        _amixer("Line DAC Playback Volume", "118,118")

        _amixer("HPCOM DAC Playback Switch", "off")

        _amixer("Left DAC_L1 Mixer HP Switch", "off")
        _amixer("Left DAC_L1 Mixer Line Switch", "on")
        _amixer("Right DAC_R1 Mixer HP Switch", "off")
        _amixer("Right DAC_R1 Mixer Line Switch", "on")
        """
        
        _amixer("Speaker Function", "0")
        

def set_speaker_volume(vol):

    # 118 is the HP DAC max setting
    vol = (vol / 100.0) * 118
    _amixer("HP DAC Playback Volume", "%d,%d" % (vol, vol))


def set_headphone_volume(vol):

    return
    # 63 is the Headphone max setting
    # 118 is the Line PGA Bypass max setting
    vol = (vol / 100.0) * 63
    #_amixer("Headphone Playback Volume", "%d,%d" % (vol, vol))
    #_amixer("Line PGA Bypass Playback Volume", "%d,%d" % (vol, vol))
    _amixer("Line DAC Playback Volume", "%d,%d" % (vol, vol))

