#include "sort.h"
#include "ui_sort.h"
#include "qsettings.h"

Sort::Sort(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Sort)
{
    ui->setupUi(this);

    ui->listWidget->clear();

    QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
    item1->setData(Qt::DisplayRole, tr("Name (A-Z)") );
    item1->setData(Qt::ToolTipRole, "1" );
    item1->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 1, item1 );

    QListWidgetItem *item2 = new QListWidgetItem( ui->listWidget );
    item2->setData(Qt::DisplayRole, tr("Name (Z-A)") );
    item2->setData(Qt::ToolTipRole, "2" );
    item2->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 2, item2 );

    QListWidgetItem *item3 = new QListWidgetItem( ui->listWidget );
    item3->setData(Qt::DisplayRole, tr("Date (recents first)") );
    item3->setData(Qt::ToolTipRole, "3" );
    item3->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 3, item3 );

    QListWidgetItem *item4 = new QListWidgetItem( ui->listWidget );
    item4->setData(Qt::DisplayRole, tr("Date (olders first)") );
    item4->setData(Qt::ToolTipRole, "4" );
    item4->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 4, item4 );

    QListWidgetItem *item5 = new QListWidgetItem( ui->listWidget );
    item5->setData(Qt::DisplayRole, tr("Size (biggers first)") );
    item5->setData(Qt::ToolTipRole, "5" );
    item5->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 5, item5 );

    QListWidgetItem *item6 = new QListWidgetItem( ui->listWidget );
    item6->setData(Qt::DisplayRole, tr("Size (smallers first)") );
    item6->setData(Qt::ToolTipRole, "6" );
    item6->setTextAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    ui->listWidget->insertItem( 6, item6 );

}

Sort::~Sort()
{
    delete ui;
}

void Sort::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue( "SortIndex", item->toolTip() );
    settings.setValue( "NeedToRefresh", "Yes" );
    settings.sync();
    this->close();

}
