/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef RECIPIENT_H
#define RECIPIENT_H

#include <QWidget>
#include <QLineEdit>
#include <QPushButton>
#include "phonebook.h"

namespace Ui {
    class Recipient;
}

class Recipient : public QWidget
{
    Q_OBJECT

public:
    explicit Recipient(QWidget *parent = 0);
    ~Recipient();
    QLineEdit* getPhoneNumberField();
    QPushButton *m_btSend;
    bool sendSMS(QString sMessage);


private:
    Ui::Recipient *ui;
    PhoneBook *m_phonebook;

public slots:
     bool addRecipient(const QString &phone, const QString &name);

private slots:
    void displayPhoneBook(QString sText);
    void openPhoneBook();
};

#endif // RECIPIENT_H
