#include <QtCore>
#include "installfile.h"
#include "repository.h"


InstallFile::InstallFile(QString filename): iIsValid(true)
{
    sections sect = sectNone;
    QStringList catalogues;
    Repository* newrepo = 0;
    QString currentRepoSect;

    qDebug() << "--reading install file" << filename;

    QFile f(filename);
    if( f.open(QIODevice::ReadOnly | QIODevice::Text) )
    {
        while( !f.atEnd() && iIsValid )
        {
            QString line = f.readLine().simplified();
            //qDebug() << ">" << line;

            if( line == "[install]" ) {
                sect = sectInstall;
                qDebug() << "install section";
            } else if( line == "[catalogues]" ) {
                sect = sectCatalogues;
                qDebug() << "catalogues section";
            } else if( line.startsWith('[') && line.endsWith(']') ) {
                sect = sectRepo;
                currentRepoSect = line.mid(1,line.length()-2);
                if( !catalogues.contains( currentRepoSect ) )
                {
                    iIsValid = false;
                    iErrorString = "File contains an unknown section";
                    sect = sectInvalid;
                    qDebug() << "unknown section" << currentRepoSect;
                } else {
                    qDebug() << "repo section" << currentRepoSect;
                    newrepo = new Repository();
                    if( !newrepo ) {
                        qDebug() << "FATAL ERROR";
                        iIsValid = false;
                        return;
                    }
                    iRepos.append(newrepo);
                }
            }

            if( sect == sectCatalogues || sect == sectInstall ) {
                if( line.startsWith("catalogues") )
                {
                    catalogues.append( TrimList( line.mid( line.indexOf('=')+1 ).split(';') ) );
                    qDebug() << catalogues;
                }
            }
            if( sect == sectInstall ) {
                if( line.startsWith("package") ) {
                    iInstallPackages.append( TrimList( line.mid( line.indexOf('=')+1 ).split(';') ) );
                    qDebug() << iInstallPackages;
                }
            }
            if( sect == sectRepo ) {
                if( line.startsWith("name") ) {
                    newrepo->setName( line.mid( line.indexOf('=')+1 ).trimmed() );
                }
                if( line.startsWith("uri") ) {
                    newrepo->setEnabled(true);
                    newrepo->setUrlDir( line.mid( line.indexOf('=')+1 ).trimmed() );
                }
                if( line.startsWith("components") ) {
                    newrepo->setComponents( line.mid( line.indexOf('=')+1 ).trimmed() );
                }
                if( line.startsWith("dist") ) {
                    newrepo->setDist( line.mid( line.indexOf('=')+1 ).trimmed() );
                }
            }

        }
        f.close();
    } else {
        iIsValid = false;
        iErrorString = "Could not open file";
        qDebug() << "could not open file";
    }

    qDebug() << "--done" << filename;

    for(int i=0; i<iRepos.count(); i++) {
        if( iRepos.at(i) ) {
            if( iRepos.at(i)->dist().isEmpty() )
                iRepos.at(i)->setDist("fremantle-1.3");  // this is not exactly the right way...
        }
    }
}

InstallFile::~InstallFile()
{
    for(int i=0; i<iRepos.count(); i++) {
        if( iRepos.at(i) ) {
            delete iRepos.at(i);
        }
    }
}

QStringList InstallFile::TrimList(QStringList l)
{
    QStringList n;
    for(int i=0; i<l.count(); i++)
    {
        n << l.at(i).trimmed();
    }
    return n;
}
