/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "searchoptions.h"
#include "ui_searchoptions.h"

SearchOptions::SearchOptions(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SearchOptions)
{
    ui->setupUi(this);
}

SearchOptions::~SearchOptions()
{
    delete ui;
}

void SearchOptions::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SearchOptions::setSelections(bool pkgname, bool dispname, bool dshort, bool dlong)
{
	ui->checkBox_pkgname->setChecked(pkgname);
	ui->checkBox_displayname->setChecked(dispname);
	ui->checkBox_descshort->setChecked(dshort);
	ui->checkBox_desclong->setChecked(dlong);
}

bool SearchOptions::searchPkgName()
{
	return ui->checkBox_pkgname->isChecked();
}

bool SearchOptions::searchDisplayName()
{
	if( !ui->checkBox_pkgname->isChecked() &&
		!ui->checkBox_descshort->isChecked() &&
		!ui->checkBox_desclong->isChecked() )
	{
		return true;
	}

	return ui->checkBox_displayname->isChecked();
}

bool SearchOptions::searchDescShort()
{
	return ui->checkBox_descshort->isChecked();
}

bool SearchOptions::searchDescLong()
{
	return ui->checkBox_desclong->isChecked();
}
