/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef REPOSITORY_H
#define REPOSITORY_H

#include <QtCore>
class Package;
class AAptInterface;

class Repository
{
public:
	Repository();

	void setName(QString n_) { iName=n_; }
	void setEnabled(bool e_) { iEnabled=e_; }

	QString name() { return iName; }
	QString url() { return iUrl; }
	QString dir() { return iDir; }
	QString dist() { return iDist; }
	QString components() { return iComponents; }
	bool enabled() { return iEnabled; }
	QString toString();
	QStringList toListFileNames();
	bool setFromString(QString repo);
	void set(QString name, QString url, QString dir_dist, QString components, bool enabled);
	void set(QString name, QString url, QString dir, QString dist, QString components, bool enabled);

private:
	QString iName;
	QString iUrl;
	QString iDir;
	QString iDist;
	QString iComponents;
	bool iEnabled;
};

#endif // REPOSITORY_H
