#include <string>
using namespace std;

#include "includes.h"
#include "screen_edit.h"
#include "txt.h"
#include "file_category.h"
#include "file_expenses.h"
#include "screen_edit.h"
#include "popup.h"
#include "string_conversion.h"
#include "screen_category.h"


string pegar_texto_categoria()
{
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(
			GTK_TEXT_VIEW(screen_edit::get_instance().__tela_categoria) );

	string atual;
	GtkTextIter start;
	GtkTextIter end;
	gchar *text;

	/* Obtain iters for the start and end of points of the buffer */
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);

	/* Get the entire buffer text. */
	text = gtk_text_buffer_get_text (buffer, &start, &end, FALSE);
	atual = text;
	g_free (text);

	return atual;
}

void botao_salvar_clicked (GtkButton* button, gpointer data)
{
	screen_edit &screen_edit_instance = screen_edit::get_instance();

	//validamos o numero (o resto nao tem validacao)
	string valor = hildon_entry_get_text ((HildonEntry*) screen_edit_instance.__tela_valor);
	string transformada = string_conversion::conversao_double2string(string_conversion::conversao_string2double(valor.c_str()));
	//123 formatado vira 123,00
	if(valor != transformada && valor.length() > transformada.length())
	{
		popup::warn(txt::tx(txt::screen_edit_numero_invalido));
		hildon_entry_set_text ( (HildonEntry*)screen_edit_instance.__tela_valor, transformada.c_str() );
		return;
	}

	//novo?
	file_expenses::dado_item novo_item;
	file_expenses::dado_item *editando = &novo_item;
	if(screen_edit_instance.__indice_sendo_editado != -1)
	{
		//aponta para o item que editamos
		editando = & file_expenses::get_instance().dados()[screen_edit_instance.__indice_sendo_editado];
	}
	else
	{
		//insere o novo item no comeco do arquivo
		file_expenses::get_instance().dados().insert(
				file_expenses::get_instance().dados().begin(),
				*editando);
		//aponta para o item que editamos
		editando = & file_expenses::get_instance().dados()[0];
	}

	//transferimos os dados
	editando->data_criacao_agora();

	guint year, month, day;
    hildon_date_button_get_date ((HildonDateButton*)screen_edit_instance.__tela_data, &year, &month, &day);
	editando->data_setar(year - 1900, month, day);

	editando->valor_set( string_conversion::conversao_string2double(valor.c_str()) );

	editando->descricao_set(pegar_texto_categoria().c_str());

	//salvamos
	if(!file_expenses::get_instance().salvar())
	{
		popup::warn(txt::tx(txt::screen_edit_erro_salvar));
	}

	//fecha a tela
	gtk_widget_hide ( GTK_WIDGET(screen_edit::get_instance().__tela_window));

	//atualiza a tela principal
	screen_main::get_instance().atualizar_grade();
}

//dia anterior
void botao_data_menos(GtkButton* buttonxx, gpointer data)
{
	HildonDateButton*button = (HildonDateButton*)screen_edit::get_instance().__tela_data;
	guint year, month, day;
	GDate *gdate = g_date_new ();

    hildon_date_button_get_date (button, &year, &month, &day);
    g_date_set_dmy (gdate, day, (GDateMonth)(month+1), year);
//g_print("%d %d %d\n", g_date_get_day(gdate), g_date_get_month(gdate), g_date_get_year (gdate));
    g_date_subtract_days(gdate, 1);
//g_print("%d %d %d\n", g_date_get_day(gdate), g_date_get_month(gdate), g_date_get_year (gdate));
    hildon_date_button_set_date ((HildonDateButton*)button, g_date_get_year (gdate),
    		g_date_get_month(gdate)-1, g_date_get_day(gdate));
    g_date_free(gdate);
}

//dia seguinte
void botao_data_mais(GtkButton* buttonxx, gpointer data)
{
	//NOTA: o mes do HildonDateButton começa em zero
	HildonDateButton*button = (HildonDateButton*)screen_edit::get_instance().__tela_data;
	guint year, month, day;
	GDate *gdate = g_date_new ();

    hildon_date_button_get_date (button, &year, &month, &day);
    g_date_set_dmy (gdate, day, (GDateMonth)(month+1), year);
//g_print("%d %d %d\n", g_date_get_day(gdate), g_date_get_month(gdate), g_date_get_year (gdate));
    g_date_add_days (gdate, 1);
//g_print("%d %d %d\n", g_date_get_day(gdate), g_date_get_month(gdate), g_date_get_year (gdate));
    hildon_date_button_set_date ((HildonDateButton*)button, g_date_get_year (gdate),
    		g_date_get_month(gdate)-1, g_date_get_day(gdate));
    g_date_free(gdate);
}


void botao_salvar_categoria_clicked (GtkButton* button, gpointer data)
{
	string atual = pegar_texto_categoria();

	file_category::get_instance().dados().push_back(atual);
	file_category::get_instance().salvar();
	popup::warn(txt::tx(txt::screen_edit_categoria_salva));
}

//vamos pedir a categoria
void botao_selecionar_categoria_clicked (GtkButton* button, gpointer data)
{
	screen_category::return_type ret =
		screen_category::get_instance().run(screen_main::get_instance().base_window);
	if(ret.retorno == screen_category::return_type::use || ret.retorno == screen_category::return_type::apeend)
	{
		GtkTextBuffer *buffer = gtk_text_view_get_buffer(
				GTK_TEXT_VIEW(screen_edit::get_instance().__tela_categoria) );

		string atual;
		GtkTextIter start;
		GtkTextIter end;
		gchar *text;

		/* Obtain iters for the start and end of points of the buffer */
		gtk_text_buffer_get_start_iter (buffer, &start);
		gtk_text_buffer_get_end_iter (buffer, &end);

		/* Get the entire buffer text. */
		text = gtk_text_buffer_get_text (buffer, &start, &end, FALSE);
		atual = text;
		g_free (text);

		if(ret.retorno == screen_category::return_type::use)
		{
			atual = ret.selecao;
		}
		else
		{
			atual = ret.selecao + atual;
		}
		gtk_text_buffer_set_text (buffer, atual.c_str(), -1);
	}
}

void botao_cancelar_clicked (GtkButton* button, gpointer data)
{
	gtk_widget_hide ( GTK_WIDGET(screen_edit::get_instance().__tela_window));
}

void botao_zero_clicado(GtkButton* button, gpointer data)
{
	screen_edit::get_instance().clicaram_valor_zero();
}

void botao_sinal_clicado(GtkButton* button, gpointer data)
{
	screen_edit::get_instance().clicaram_valor_sinal();
}

//as rotinas dos botoes de valores
#define rotina_botao_mais_menos(txtmsg, rotina)	\
void rotina(GtkButton* button, gpointer data)	\
{	\
	screen_edit::get_instance().clicaram_valor( atoi(txt::tx(txtmsg)));	\
}
rotina_botao_mais_menos(txt::screen_edit_menos_100, botao_menos_100)
rotina_botao_mais_menos(txt::screen_edit_menos_25, botao_menos_25)
rotina_botao_mais_menos(txt::screen_edit_menos_10, botao_menos_10)
rotina_botao_mais_menos(txt::screen_edit_menos_5, botao_menos_5)
rotina_botao_mais_menos(txt::screen_edit_menos_1, botao_menos_1)
rotina_botao_mais_menos(txt::screen_edit_mains_100, botao_mains_100)
rotina_botao_mais_menos(txt::screen_edit_mains_25, botao_mains_25)
rotina_botao_mais_menos(txt::screen_edit_mains_10, botao_mains_10)
rotina_botao_mais_menos(txt::screen_edit_mains_5, botao_mains_5)
rotina_botao_mais_menos(txt::screen_edit_mains_1, botao_mains_1)


/*
 * vamos construir a tela
 */
void screen_edit::construir_tela(HildonWindow *window_pai)
{
    //ele destroi automaticamente, nao sei onde
	//se a gente fechar, nao destruimos; mas se fechar pelo botao de cima, ele destroi
	if(__tela_window != NULL)
		if(GTK_IS_WINDOW(__tela_window))
			return;

    __tela_window = hildon_stackable_window_new ();

    //botoes de mais e menos
    GtkWidget *area_valor = gtk_hbox_new(FALSE, 1);
    {
    GtkWidget *barra_botoes_numeros_andares = gtk_vbutton_box_new();
    GtkWidget *barra_botoes_numeros = gtk_hbutton_box_new();
    //GtkWidget *barra_botoes_numeros = gtk_hbox_new(FALSE, 1);
    GtkWidget *botao_sendo_criado;

#define botao_mais_menos(txtmsg, rotina)	\
    botao_sendo_criado = gtk_button_new_with_label( txt::tx(txtmsg));	\
    gtk_container_add (GTK_CONTAINER(barra_botoes_numeros), botao_sendo_criado);	\
	g_signal_connect (G_OBJECT (botao_sendo_criado), "clicked", G_CALLBACK (rotina), NULL)

    /*
     * nao colocamos
    botao_sendo_criado = gtk_button_new_with_label("0");	\
    gtk_container_add (GTK_CONTAINER(barra_botoes_numeros), botao_sendo_criado);	\
	g_signal_connect (G_OBJECT (botao_sendo_criado), "clicked", G_CALLBACK (botao_zero_clicado), NULL);
     */
    botao_mais_menos(txt::screen_edit_menos_100, botao_menos_100);
    botao_mais_menos(txt::screen_edit_menos_25, botao_menos_25);
	botao_mais_menos(txt::screen_edit_menos_10, botao_menos_10);
	botao_mais_menos(txt::screen_edit_menos_5, botao_menos_5);
	botao_mais_menos(txt::screen_edit_menos_1, botao_menos_1);
	gtk_container_add (GTK_CONTAINER(barra_botoes_numeros_andares), barra_botoes_numeros);

	barra_botoes_numeros = gtk_hbutton_box_new();
    /*
     * nao colocamos
    botao_sendo_criado = gtk_button_new_with_label("-");	\
    gtk_container_add (GTK_CONTAINER(barra_botoes_numeros), botao_sendo_criado);	\
	g_signal_connect (G_OBJECT (botao_sendo_criado), "clicked", G_CALLBACK (botao_sinal_clicado), NULL);
	*/
    botao_mais_menos(txt::screen_edit_mains_100, botao_mains_100);
    botao_mais_menos(txt::screen_edit_mains_25, botao_mains_25);
    botao_mais_menos(txt::screen_edit_mains_10, botao_mains_10);
    botao_mais_menos(txt::screen_edit_mains_5, botao_mains_5);
    botao_mais_menos(txt::screen_edit_mains_1, botao_mains_1);
	gtk_container_add (GTK_CONTAINER(barra_botoes_numeros_andares), barra_botoes_numeros);

	//campo de valor
	__tela_valor = hildon_entry_new ((HildonSizeType)(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT));
	hildon_gtk_entry_set_input_mode (GTK_ENTRY(__tela_valor), (HildonGtkInputMode)(HILDON_GTK_INPUT_MODE_NUMERIC | HILDON_GTK_INPUT_MODE_SPECIAL ));
	//hildon_entry_set_text ( (HildonEntry*)digitare, "123,45");
	g_object_set(__tela_valor, "xalign", 1.0, NULL);

	//empacotando tudo
    gtk_container_add (GTK_CONTAINER(area_valor), __tela_valor);
    gtk_container_add (GTK_CONTAINER(area_valor), barra_botoes_numeros_andares);
    }


    //area de digitacao
    GtkWidget *categoria_scroll;
    {
    	__tela_categoria = gtk_text_view_new ();
    	g_object_set(__tela_categoria, "accepts-tab", FALSE, NULL);
    	g_object_set(__tela_categoria, "editable", TRUE, NULL);
    	g_object_set(__tela_categoria, "wrap-mode", GTK_WRAP_WORD_CHAR, NULL);
    	categoria_scroll =hildon_pannable_area_new();
    	hildon_pannable_area_set_size_request_policy( (HildonPannableArea*)categoria_scroll, HILDON_SIZE_REQUEST_CHILDREN );
    	hildon_pannable_area_add_with_viewport ( (HildonPannableArea*)categoria_scroll, __tela_categoria);
    }


    //selecao da data
    GtkWidget *barra_data;
    {
		__tela_data = hildon_date_button_new((HildonSizeType)(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT), HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
		barra_data = gtk_hbox_new(FALSE, 1);
		gtk_box_pack_start(GTK_BOX(barra_data), __tela_data, TRUE, TRUE, 10);
		GtkWidget *botao_criar1 = gtk_button_new_with_label(_("<<"));
		gtk_box_pack_start(GTK_BOX(barra_data), botao_criar1, FALSE, FALSE, 10);
		g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_data_menos), NULL);
		botao_criar1 = gtk_button_new_with_label(_(">>"));
		gtk_box_pack_start(GTK_BOX(barra_data), botao_criar1, FALSE, FALSE, 10);
		g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_data_mais), NULL);
    }

    //a barra inferior de botoes
    GtkWidget *barra_inferior_botoes;
    {
    	barra_inferior_botoes = gtk_hbutton_box_new();

    	GtkWidget *botao_criar1 = gtk_button_new_with_label(txt::tx(txt::screen_edit_salvar_categ));
    	gtk_container_add (GTK_CONTAINER(barra_inferior_botoes), botao_criar1);
    	g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_salvar_categoria_clicked), NULL);

    	botao_criar1 = gtk_button_new_with_label(txt::tx(txt::screen_edit_select_categ));
    	gtk_container_add (GTK_CONTAINER(barra_inferior_botoes), botao_criar1);
    	g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_selecionar_categoria_clicked), NULL);

    	HildonSizeType sizetype = (HildonSizeType)(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
    	botao_criar1 = hildon_button_new_with_text (sizetype, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
    			txt::tx(txt::screen_edit_salvar), NULL);
    	g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_salvar_clicked), NULL);
    	gtk_container_add (GTK_CONTAINER(barra_inferior_botoes), botao_criar1);

    	botao_criar1 = hildon_button_new_with_text (sizetype, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
    			txt::tx(txt::screen_edit_cancelar), NULL);
    	g_signal_connect (G_OBJECT (botao_criar1), "clicked", G_CALLBACK (botao_cancelar_clicked), NULL);
    	gtk_container_add (GTK_CONTAINER(barra_inferior_botoes), botao_criar1);
    }

    //montagem final da tela
	GtkWidget *tela_inteira = gtk_vbox_new(FALSE, 1);
	gtk_container_add (GTK_CONTAINER(__tela_window), tela_inteira);
	gtk_box_pack_start(GTK_BOX(tela_inteira), area_valor, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(tela_inteira), barra_data, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(tela_inteira), categoria_scroll, TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(tela_inteira), barra_inferior_botoes, FALSE, FALSE, 5);

	//gtk_widget_show_all (dialog);
	gtk_window_set_transient_for(GTK_WINDOW(__tela_window), GTK_WINDOW(window_pai));
}

