#ifndef NoCopyConstructor_h
#define NoCopyConstructor_h

class NoCopyConstructor {
public:
NoCopyConstructor() {}
private:
NoCopyConstructor(const NoCopyConstructor& x); // no copy constructor
};

/*
singleton
 no copy constructor
para usar: dentro da classe, colocar singleton(nome_da_classe)
e precisa definir a variavel estatica com singleton_variable(nome_da_classe)
*/
#define singleton(T)	\
	private:	\
		T() { T##_instance = NULL; _constructor(); }	\
		T(const T& x);	\
		~T() \
		{  \
			_destructor(); \
		} \
		static T *T##_instance; \
	public:	\
		static T &get_instance() \
		{ \
			if(T##_instance == NULL) T##_instance = new T(); \
			return *T##_instance; \
		} \
		static void delete_instance() \
		{ \
			if(T##_instance != NULL) delete T##_instance; \
			T##_instance = NULL; \
		} \


#define singleton_variable(T)	\
	T *T::T##_instance = NULL;



#endif
