#include <QtGui>
#include "fontclock.h"

//FontClock::FontClock(QColor &aColor, QString &aFormat, QFont &aFont, int aBlink1, int aBlink2, QWidget *parent) :
//    QWidget(parent), m_font(aFont), m_color(aColor), m_format(aFormat), m_blink1(aBlink1), m_blink2(aBlink2)
FontClock::FontClock(QColor &aColor, QFont &aFont, QString &aTime, QSize &aSize) :
    QWidget(0), m_font(aFont), m_color(aColor), m_text(aTime)
{
//    QSize aa = aSize;
    setAttribute(Qt::WA_TranslucentBackground);
    resize(aSize);
    calcFontSize();
    showTime(m_text);
}

void FontClock::calcFontSize()
{
    int wd_width = size().width();
    int wd_hgt = size().height();

    QString fFamily = m_font.family();
    // calc font size
    m_fntSize = 20;
    for (int i = 0; i < 200; i++)
    {
        QFont f(fFamily,i);
        QFontMetrics fm(f);

        int x = fm.width(m_text);
        int y = fm.height();

        if ((x > wd_width) || (y > wd_hgt))
        {
            m_fntSize = i-1;
            break;
        }
    }
    m_font.setPointSize(m_fntSize);
}

void FontClock::showTime(QString aTime)
{
    m_text = aTime;
    update();
}

void FontClock::paintEvent(QPaintEvent* event)
{
    Q_UNUSED(event);
    QPainter p(this);
    p.setFont(m_font);
    p.setPen(m_color);

    p.drawText(rect(), Qt::AlignTop | Qt::AlignHCenter, m_text);
}

void FontClock::resizeEvent (QResizeEvent * event )
{
    Q_UNUSED(event);
    calcFontSize();
}

void FontClock::rotate()
{
    int wd = size().width();
    int hg = size().height();
    resize(QSize(hg,wd));
//    calcFontSize();
}
