#ifndef DIGITALCLOCKWDG_H
#define DIGITALCLOCKWDG_H

//#include <QWidget>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <QPushButton>
//class QGraphicsView;
//class QGraphicsScene;

//class SettingsDialog;

class DigitalClockWdg : public QGraphicsView
{
    Q_OBJECT

signals:
    void updateClock(QString);
    void rotateClock();

public slots:
    void showSettingsDialog();
    void homeScreenChanged(bool isOnCurrentHomescreen);
    void orientationChanged(QString aMessage);

public:
    DigitalClockWdg(QGraphicsScene *scene);
    void setId(QString &aAppletId);

protected:
    void mouseReleaseEvent ( QMouseEvent * e );
    void mousePressEvent ( QMouseEvent * e );
//    void moveEvent ( QMoveEvent * event );
//    void paintEvent(QPaintEvent *event);

private slots:
    void showTime();

private:
    void loadSettings();
    void initClock();
    void showClock();
    QTime calcTime();
    QString calcDate();
//    void enableRotationMonitor(bool aRotatable);
    void enableRotationMonitor(int aRotatePolicy);
    int drawCityName();
    int drawDate();
    void calcOffset();

private:
    QWidget * clk1;
    bool m_lcd;
    QFont m_font;

    QTimer *m_timer;
    QColor m_digitColor;
    QSize m_size;
    int m_timer_tick;
    QString m_timeFormat;
    bool m_mouseClick;
    QPoint m_lastPoint;
    int m_blinking1;
    int m_blinking2;
    int m_tzOffset;
    QString m_aplletId;
    float m_transparency;

    QGraphicsScene* m_scene;
    QGraphicsProxyWidget *m_gProxy;
    QGraphicsLineItem *m_gLine;
    QGraphicsTextItem *m_gCity;
    QGraphicsLineItem *m_gLine2;
    QGraphicsTextItem *m_gDate;
    QGraphicsPixmapItem * mBgImage;

    int m_sc_x;
    int m_sc_y;

    bool m_rotate;
    bool m_openclock;
    bool m_showCity;
    QString m_cityName;
    int m_citySize;
    int m_hCity;
    int m_wCity;
    int m_corner;

    QString m_dateString;
    bool m_showDate;
    bool m_fullDateFormat;
    int m_dateSize;
    int m_hDate;
    int m_wDate;

    int mCityIndex;
//    int m_x;
//    int m_y;
};

#endif
