#ifndef DCLOCKSETTINGS_H
#define DCLOCKSETTINGS_H
#include <QSize>
#include <QColor>
#include <QFont>

class dclocksettings
{
public:
    static dclocksettings& getInstance()
    {
        static dclocksettings instance; // Guaranteed to be destroyed.
        // Instantiated on first use.
        return instance;
    }

    //get/set widget size;
    QSize getSize(const QString &aAplletId) const;
    void setSize(const QString &aAplletId, const QSize &aSize) const;
    //get/set color of digits
    QColor getColor(const QString &aAplletId) const;
    void setColor(const QString &aAplletId, const QColor &aColor) const;
    //get/set show seconds flag
    bool isShowSeconds(const QString &aAplletId) const;
    void setShowSeconds(const QString &aAplletId, const bool &aShow) const;
    //get/set time format
    int getTimeFormat(const QString &aAplletId) const;
    void setTimeFormat(const QString &aAplletId, const int &aFormatIdx) const;
    //get/set LCD
    bool isLcd(const QString &aAplletId) const;
    void setLcd(const QString &aAplletId, const bool &aLcd) const;
    //get/set font
    QFont getFont(const QString &aAplletId) const;
    void setFont(const QString &aAplletId, const QFont &aFont) const;
    //get/set blinking
    bool isBlinking(const QString &aAplletId) const;
    void setBlinking(const QString &aAplletId, const bool &aBlink) const;
    //get/set time zone
    int getTZoffset(const QString &aAplletId) const;
    void setTZoffset(const QString &aAplletId, const int &aOffset) const;
    //get/set time zone index
    int getTZindex(const QString &aAplletId) const;
    void setTZindex(const QString &aAplletId, const int &aIndex) const;
    //get/set time zone city
    QString getTZcity(const QString &aAplletId) const;
    void setTZcity(const QString &aAplletId, const QString &aCity) const;
    //get/set transparency
    int getTransparency(const QString &aAplletId) const;
    void setTransparency(const QString &aAplletId, const int &aTrans) const;
    //get/set rotatable
//    bool isRotateEnabled(const QString &aAplletId) const;
//    void setRotateEnabled(const QString &aAplletId, const bool &aRotate) const;
    //TODO new rotation feature
    int getRotatePolicy(const QString &aAplletId) const;
    void setRotatePolicy(const QString &aAplletId, const int &aRotate) const;
    //get/set open clock
    bool isOpenClockEnabled(const QString &aAplletId) const;
    void setOpenClockEnabled(const QString &aAplletId, const bool &aOpenClock) const;
    //get/set show city
    bool isShowCityEnabled(const QString &aAplletId) const;
    void setShowCityEnabled(const QString &aAplletId, const bool &aShow) const;
    //get/set city size
    int getCitySize(const QString &aAplletId) const;
    void setCitySize(const QString &aAplletId, const int &aSize) const;
    //get/set Corner Number
    int getCornerNumber(const QString &aAplletId) const;
    void setCornerNumber(const QString &aAplletId, const int &aNumber) const;
    //get/set show date
    bool isShowDateEnabled(const QString &aAplletId) const;
    void setShowDateEnabled(const QString &aAplletId, const bool &aShow) const;
    //get/set full date format
    bool isFullDateFormat(const QString &aAplletId) const;
    void setFullDateFormat(const QString &aAplletId, const bool &aFull) const;
    //get/set date size
    int getDateSize(const QString &aAplletId) const;
    void setDateSize(const QString &aAplletId, const int &aSize) const;
    //get/set widget's position
//    QPoint getPosition(const QString &aAplletId) const;
//    void setPosition(const QString &aAplletId, const QPoint &aPos) const;
    //get/set image
    QString getImageFile(const QString &aAplletId) const;
    void setImageFile(const QString &aAplletId, const QString &aFile) const;

private:
    dclocksettings() {}
    dclocksettings(dclocksettings const&);              // Don't Implement
    void operator=(dclocksettings const&); // Don't implement
};

#endif // DCLOCKSETTINGS_H
