/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

import "core"
import "common"

Rectangle {
    id: main
    width: 800
    height: 480
    color: '#00d300'

    property int columns: 10
    property int rows: 10
    property int mines: 14

    Flickable {
        id:  flickable
        anchors.fill: parent
        contentWidth: (main.width / 10) * columns
        contentHeight: (main.width / 10) * rows
        Table {
            id: table
            /*width: (main.width / 10) * (columns * (1 + table.spacing) )
            height: (main.width / 10) * (rows * (1 + table.spacing) )*/
            onLost: main.lost()
            onWon: main.won()
            columns: main.columns
            rows: main.rows
            numOfMines: main.mines
            fieldSize: main.width / 10
        }
    }

    Dialog {
        id: dialog
        onClosed: main.newGame();
    }

    Options {
        id: options
        onSaved: {
            columns = numOfColumns;
            rows = numOfRows;
            mines = numOfMines;
            table.initialize();
            flickable.contentHeight = (main.width / 10) * rows;
            flickable.contentWidth = (main.width / 10) * columns;
            newGame();
        }
        onCanceled: {

        }
    }

    function openOptions() {
        options.show();
    }

    function newGame() {
        table.newGame();
        flickable.contentX = 0;
        flickable.contentY = 0;
    }

    function lost() {
        dialog.show('Game over.');
    }

    function won() {
        dialog.show('You won!');
    }
}
