#ifndef YOUTUBEUSERLISTWINDOW_H
#define YOUTUBEUSERLISTWINDOW_H

#include "stackedwindow.h"
#include "youtubeuserlistmodel.h"
#include "listview.h"
#include <QLabel>

class YouTubeUserListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeUserListWindow(Session *session, QWidget *parent);
    void setFeed(const QString &feed);
    void search(const QString &query);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showUserChannel(const QString &userId);

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);

private:
    YouTubeUserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEUSERLISTWINDOW_H
