#include "youtubeplaylistdialog.h"
#include "youtubeplaylistdelegate.h"
#include "youtubenewplaylistdialog.h"

YouTubePlaylistDialog::YouTubePlaylistDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_model(new YouTubeUserPlaylistListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_newButton(m_buttonBox->addButton(tr("New playlist"), QDialogButtonBox::ActionRole)),
    m_noResultsLabel(new QLabel(tr("No playlists found"), this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Add to playlist"));
    toggleBusy(true);

    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));

    QFont font;
    font.setPixelSize(40);
    font.setBold(true);
    m_noResultsLabel->setFont(font);
    m_noResultsLabel->setAlignment(Qt::AlignCenter);
    m_noResultsLabel->hide();

    connect(m_newButton, SIGNAL(clicked()), this, SLOT(showNewPlaylistDialog()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    if (m_session->youtube()->playlistsLoaded()) {
        onPlaylistsLoaded();
    }
    else {
        connect(m_session->youtube(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    onOrientationChanged();
}

void YouTubePlaylistDialog::setLandscapeLayout() {
    setFixedHeight(340);
    m_noResultsLabel->setFixedSize(800, 340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void YouTubePlaylistDialog::setPortraitLayout() {
    setFixedHeight(600);
    m_noResultsLabel->setFixedSize(480, 600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void YouTubePlaylistDialog::onPlaylistsLoaded() {
    toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);
}

void YouTubePlaylistDialog::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        emit playlistChosen(index.data(YouTubeUserPlaylistListModel::PlaylistIdRole).toString());
        accept();
    }
}

void YouTubePlaylistDialog::showNewPlaylistDialog() {
    YouTubeNewPlaylistDialog *dialog = new YouTubeNewPlaylistDialog(this);
    dialog->open();
    connect(dialog, SIGNAL(playlistCreated(NewPlaylist)), this, SIGNAL(addToNewPlaylist(NewPlaylist)));
    connect(dialog, SIGNAL(accepted()), this, SLOT(accept()));
}
