#ifndef YOUTUBEVIDEOSELECTIONWINDOW_H
#define YOUTUBEVIDEOSELECTIONWINDOW_H

#include "abstractvideolistmodel.h"
#include "session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

class VideoSelectionWindow : public QWidget
{
    Q_OBJECT
public:
    explicit VideoSelectionWindow(Session *session, AbstractVideoListModel *model, Services::VideoService service, const QString &text, const char* slot, QWidget *parent);
    ~VideoSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void showPlaylistDialog();
    void addVideosToPlaylist(const QString &id);
    void addVideosToNewPlaylist(const NewPlaylist &playlist);
    void addVideosToWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    
signals:
    void accepted();
    
private:
    Session *m_session;
    AbstractVideoListModel *m_model;
    Services::VideoService m_service;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // YOUTUBEVIDEOSELECTIONWINDOW_H
