#include "videoitem.h"

VideoItem::VideoItem(QObject *parent) :
    QObject(parent),
    m_checked(false)
{
}

VideoItem::VideoItem(const QVariantMap &video, bool favourite, QObject *parent) :
    QObject(parent),
    m_id(video.value("id").toString()),
    m_video_id(id()),
    m_url("http://dai.ly/" + videoId()),
    m_title(video.value("title").toString()),
    m_artist(video.value("owner.username").toString()),
    m_artist_id(video.value("owner.id").toString()),
    m_artist_avatar_url(video.value("owner.avatar_medium_url").toString()),
    m_description(video.value("description").toString()),
    m_duration(video.value("duration").toInt()),
    m_date(Utils::dateFromSecs(video.value("created_time").toLongLong())),
    m_tags(video.value("tags").toStringList()),
    m_likes(0),
    m_dislikes(0),
    m_rating_count(video.value("ratings_total").toInt()),
    m_rating(video.value("rating").toFloat()),
    m_view_count(video.value("views_total").toInt()),
    m_thumb_url(video.value("thumbnail_medium_url").toString()),
    m_large_thumb_url(video.value("thumbnail_large_url").toString()),
    m_liked(false),
    m_disliked(false),
    m_favourite(favourite),
    m_downloaded(false),
    m_private(video.value("private").toBool()),
    m_service(Services::Dailymotion),
    m_checked(false)
{
    emit favouriteChanged();
    emit downloadedChanged();
}

VideoItem::VideoItem(const QDomNode &video, bool favourite, QObject *parent) :
    QObject(parent),
    m_id(video.firstChildElement("id").text()),
    m_video_id(video.firstChildElement("media:group").firstChildElement("yt:videoid").text()),
    m_url("http://youtu.be/" + videoId()),
    m_title(video.firstChildElement("media:group").firstChildElement("media:title").text()),
    m_artist(video.firstChildElement("media:group").firstChildElement("media:credit").attribute("yt:display")),
    m_artist_id(video.firstChildElement("media:group").firstChildElement("yt:uploaderId").text().section("UC", 1, -1)),
    m_artist_avatar_url("http://i2.ytimg.com/i/" + artistId() + "/1.jpg"),
    m_description(video.firstChildElement("media:group").firstChildElement("media:description").text()),
    m_duration(video.firstChildElement("media:group").firstChildElement("yt:duration").attribute("seconds").toInt()),
    m_date(Utils::localDateTimeFromString(video.firstChildElement("media:group").firstChildElement("yt:uploaded").text())),
    m_likes(video.firstChildElement("yt:rating").attribute("numLikes").toInt()),
    m_dislikes(video.firstChildElement("yt:rating").attribute("numDislikes").toInt()),
    m_rating_count(likes() + dislikes()),
    m_rating(likes() == 0 ? 0 : dislikes() == 0 ? 100 : int((float(likes()) / ratingCount()) * 100)),
    m_view_count(video.firstChildElement("yt:statistics").attribute("viewCount").toInt()),
    m_thumb_url(video.firstChildElement("media:group").firstChildElement("media:thumbnail").attribute("url")),
    m_large_thumb_url(thumbnailUrl().toString().section('/', 0, -2).append("/hqdefault.jpg")),
    m_liked(false),
    m_disliked(false),
    m_favourite(favourite),
    m_downloaded(false),
    m_private(!video.firstChildElement("yt:private").isNull()),
    m_service(Services::YouTube),
    m_checked(false)
{
    QDomElement tagElement = video.firstChildElement("category");

    while (!tagElement.isNull()) {
        m_tags.append(tagElement.attribute("term"));
        tagElement = tagElement.nextSiblingElement("category");
    }

    emit favouriteChanged();
    emit downloadedChanged();
}
