#ifndef TRANSFERITEM_H
#define TRANSFERITEM_H

#include "videoitem.h"
#include "videometadata.h"

class TransferItem : public QObject
{
    Q_OBJECT

    Q_ENUMS(TransferItem::Status TransferItem::TransferType TransferItem::Priority)

public:
    enum TransferType {

        VideoDownload = 0,
        AudioDownload,
        VideoUpload
    };

    enum Status {

        Queued = 0,
        Paused,
        Active,
        Cancelled,
        Failed,
        Completed
    };

    enum Priority {

        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

public:
    explicit TransferItem(QObject *parent = 0);
    explicit TransferItem(QSharedPointer<VideoItem> video, TransferItem::TransferType type, TransferItem::Status status, QObject *parent = 0);
    explicit TransferItem(const VideoMetadata &upload, QObject *parent = 0);
    inline ~TransferItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline TransferItem::TransferType transferType() const { return m_transferType; }
    inline void setTransferType(TransferItem::TransferType type) { m_transferType = type; }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString filePath() const { return m_filepath; }
    inline void setFilePath(const QString &filePath) { m_filepath = filePath; }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }
    inline TransferItem::Status status() const { return m_status; }
    QString statusText() const;
    inline QString statusInfo() const { return m_statusInfo; }
    inline TransferItem::Priority priority() const { return m_priority; }
    inline float progress() const { return m_progress; }
    inline int eta() const { return m_eta; }
    inline void setProgress(float progress, int eta) { m_progress = progress; m_eta = eta; }
    inline void setStatus(TransferItem::Status status) { m_status = status; }
    inline void setStatusInfo(const QString &info) { m_statusInfo = info; }
    inline void setPriority(TransferItem::Priority priority) { m_priority = priority; }
    QString priorityText() const;
    inline qint64 size() const { return m_size; }
    inline void setSize(qint64 size) { m_size = size; }
    inline VideoMetadata upload() const { return m_upload; }
    inline Qualities::VideoQuality quality() const { return m_quality; }
    inline void setQuality(Qualities::VideoQuality quality) { m_quality = quality; }

private:
    TransferItem::TransferType m_transferType;
    Services::VideoService m_service;
    QString m_id;
    QString m_title;
    QString m_filepath;
    QUrl m_thumbnailUrl;
    TransferItem::Status m_status;
    QString m_statusText;
    QString m_statusInfo;
    TransferItem::Priority m_priority;
    float m_progress;
    int m_eta;
    qint64 m_size;
    QString m_priorityText;
    VideoMetadata m_upload;
    Qualities::VideoQuality m_quality;
};

#endif // TRANSFERITEM_H
