#ifndef SEARCHTYPESELECTOR_H
#define SEARCHTYPESELECTOR_H

#include "selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class SearchTypeSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit SearchTypeSelector(const QString &text, QWidget *parent = 0);
    void setValue(Queries::QueryType value);
    Queries::QueryType currentValue();
    void showGroups(bool show);

private slots:
    void onSelected();

signals:
    void valueChanged(Queries::QueryType value);

private:
    SearchTypeModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // SEARCHTYPESELECTOR_H
