#include "searchlistmodel.h"

SearchListModel::SearchListModel(QObject *parent) :
    QSortFilterProxyModel(parent),
    m_model(new QStringListModel(this)),
    m_settings(new QSettings("Marxian", "cuteTube", this))
{
    setSourceModel(m_model);
    setFilterRole(Qt::DisplayRole);
    setDynamicSortFilter(true);

    m_settings->beginGroup("Search");
    setSearches(m_settings->value("recentSearches", QStringList()).toStringList());
    m_settings->endGroup();
}

SearchListModel::~SearchListModel() {
    saveSearches();
}

void SearchListModel::saveSearches() {
    QStringList strings;
    int i = 0;

    while ((i < 50) && (i < m_model->stringList().size())) {
        strings << m_model->stringList().at(i);
        i++;
    }

    m_settings->beginGroup("Search");
    m_settings->setValue("recentSearches", strings);
    m_settings->endGroup();
}

void SearchListModel::setSearches(const QStringList &searches) {
    m_model->setStringList(searches);
}

void SearchListModel::setQuery(const QString &query) {
    m_query = query;
    setFilterRegExp(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));
    emit dataChanged(index(0, 0), index(rowCount() - 1, 0));
}

QString SearchListModel::regexMatch(QString str) const {
    QRegExp re(filterRegExp());

    if ((!re.isEmpty()) && (re.indexIn(str) > -1)) {
        str.replace(re, "<b>" + re.cap() + "</b>");
    }

    return str;
}

void SearchListModel::addSearch(const QString &query) {
    beginResetModel();
    int i = m_model->stringList().indexOf(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));

    if (i >= 0) {
        removeRow(i);
    }

    insertRow(0);
    setData(index(0, 0), query, 0);
    endResetModel();
}

void SearchListModel::removeSearch(int row) {
    removeRow(row);
}

void SearchListModel::clearSearches() {
    beginResetModel();
    m_model->setStringList(QStringList());
    endResetModel();

    emit alert(tr("Search history cleared"));
}

QVariant SearchListModel::data(const QModelIndex &index, int role) const {
    return query().isEmpty() ? m_model->data(mapToSource(index), role) : regexMatch(m_model->data(mapToSource(index), role).toString());
}
