#ifndef DAILYMOTIONPLAYLISTLISTTAB_H
#define DAILYMOTIONPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "listview.h"
#include "dailymotionplaylistlistmodel.h"
#include <QLabel>
#include <QGridLayout>

class DailymotionPlaylistListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionPlaylistListTab(Session *session, QWidget *parent = 0);
    void setPlaylistFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    Session *m_session;
    ListView *m_listView;
    DailymotionPlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPLAYLISTLISTTAB_H
