#include "categoriesdialog.h"
#include "textlistdelegate.h"

CategoriesDialog::CategoriesDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_youtubeLabel(new SeparatorLabel("YouTube", this)),
    m_dailymotionLabel(new SeparatorLabel("Dailymotion", this)),
    m_youtubeModel(new YouTubeCategoryModel(this)),
    m_dailymotionModel(new DailymotionCategoryModel(this)),
    m_youtubeView(new ListView(this)),
    m_dailymotionView(new ListView(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Categories"));
    m_youtubeView->setModel(m_youtubeModel);
    m_youtubeView->setItemDelegate(new TextListDelegate(Qt::AlignVCenter, m_youtubeView));
    m_dailymotionView->setModel(m_dailymotionModel);
    m_dailymotionView->setItemDelegate(new TextListDelegate(Qt::AlignVCenter, m_dailymotionView));

    connect(m_youtubeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onYouTubeCategoryChosen(QModelIndex)));
    connect(m_dailymotionView, SIGNAL(clicked(QModelIndex)), this, SLOT(onDailymotionCategoryChosen(QModelIndex)));

    onOrientationChanged();
}

void CategoriesDialog::setLandscapeLayout() {
    setFixedHeight(340);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_youtubeLabel, 0, 0);
        m_grid->addWidget(m_dailymotionLabel, 0, 1);
        m_grid->addWidget(m_youtubeView, 1, 0);
        m_grid->addWidget(m_dailymotionView, 1, 1);
    }
    else {
        m_grid->removeWidget(m_dailymotionLabel);
        m_grid->removeWidget(m_dailymotionView);
        m_grid->addWidget(m_dailymotionLabel, 0, 1);
        m_grid->addWidget(m_dailymotionView, 1, 1);
    }
}

void CategoriesDialog::setPortraitLayout() {
    setFixedHeight(600);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_youtubeLabel, 0, 0);
        m_grid->addWidget(m_youtubeView, 1, 0);
        m_grid->addWidget(m_dailymotionLabel, 2, 0);
        m_grid->addWidget(m_dailymotionView, 3, 0);
    }
    else {
        m_grid->removeWidget(m_dailymotionLabel);
        m_grid->removeWidget(m_dailymotionView);
        m_grid->addWidget(m_dailymotionLabel, 2, 0);
        m_grid->addWidget(m_dailymotionView, 3, 0);
    }
}

void CategoriesDialog::onYouTubeCategoryChosen(const QModelIndex &index) {
    emit categoryChosen(Services::YouTube, m_youtubeModel->name(index.row()), m_youtubeModel->value(index.row()).toString());
    accept();
}

void CategoriesDialog::onDailymotionCategoryChosen(const QModelIndex &index) {
    emit categoryChosen(Services::Dailymotion, m_dailymotionModel->name(index.row()), m_dailymotionModel->value(index.row()).toString());
    accept();
}
