#ifndef CURRENCYSETTINGS_H
#define CURRENCYSETTINGS_H

#include <QMainWindow>
#include <QSettings>
#include <QModelIndex>
#include <QInputDialog>
#include "currencyedit.h"
#include "help.h"

namespace Ui {
    class CurrencySettings;
}

class CurrencySettings : public QMainWindow {
    Q_OBJECT
public:
    CurrencySettings(QWidget *parent = 0);
    ~CurrencySettings();

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject *obj, QEvent *ev);

private:
    Ui::CurrencySettings *ui;
    QSettings mvSettings;
    QString mvCurrency1;
    QString mvCurrency2;
    bool mvAutoUpdate;
    CurrencyEdit *currencyEdit;
    Help *helpWindow;

    void displayRate();
    void updateList();

private slots:
    void on_actionHelp_triggered();
    void on_pushButton_Delete_clicked();
    void on_pushButton_Preset_clicked();
    void on_pushButton_Foreign_clicked();
    void on_pushButton_Home_clicked();
    void on_checkBox_AutoUpdate_clicked(bool checked);
    void on_pushButton_Edit_clicked();
    void on_pushButton_Apply_clicked();

};

#endif // CURRENCYSETTINGS_H
