#include "edit.h"
#include "ui_edit.h"

Edit::Edit(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Edit)
{
    ui->setupUi(this);
    updateList();
    ui->lineEdit_rate->setValidator(new QDoubleValidator(0, 9999999, 6, this));
}

Edit::~Edit()
{
    delete ui;
}

void Edit::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Edit::updateList()
{
    mvSettings.beginGroup("Currency");
    QStringList allCurrencies = mvSettings.allKeys();
    QString currencyName;
    QStringList currencyNames;
    mvSettings.endGroup();

    mvSettings.beginGroup("CurrencyName");
    foreach (QString currency, allCurrencies) {
        currencyName = currency + " - " + mvSettings.value(currency).toString();
        currencyNames += currencyName;
    }
    mvSettings.endGroup();

    ui->listWidget->clear();
    ui->listWidget->addItems(currencyNames);
}

void Edit::clearFields()
{
    ui->lineEdit_currency->clear();
    ui->lineEdit_description->clear();
    ui->lineEdit_rate->clear();
}

void Edit::on_listWidget_clicked(QModelIndex index)
{
    QString selection = ui->listWidget->currentItem()->text().left(3);

    ui->lineEdit_currency->setText(selection);
    ui->lineEdit_description->setText(mvSettings.value("CurrencyName/" + selection).toString());
    ui->lineEdit_rate->setText(mvSettings.value("Currency/" + selection).toString());
    ui->pushButton_Add->setText("Modify");

}

void Edit::on_pushButton_Add_clicked()
{
    QString currency = ui->lineEdit_currency->text();

    if (currency != "EUR") {
        mvSettings.setValue("CurrencyName/" + currency, ui->lineEdit_description->text());
        mvSettings.setValue("Currency/" + currency, ui->lineEdit_rate->text());
        updateList();
        clearFields();
        ui->pushButton_Add->setText("Add");
    }
}

void Edit::on_pushButton_Remove_clicked()
{
    QString currency = ui->lineEdit_currency->text();

    if (currency != "EUR") {
        mvSettings.remove("CurrencyName/" + currency);
        mvSettings.remove("Currency/" + currency);
        if  (mvSettings.value("Currency1") == currency) {
            mvSettings.setValue("Currency1", "EUR");
        }
        if  (mvSettings.value("Currency2") == currency) {
            mvSettings.setValue("Currency2", "EUR");
        }
        updateList();
        clearFields();
    }
}

void Edit::on_pushButton_Restore_clicked()
{
    QMessageBox::StandardButton reply;
    reply = QMessageBox::warning(this, tr("Warning!"),
                                  "You will loose all your personal settings. " \
                                  "You will need to restart the application " \
                                  "before the changes take effect.",
                                  QMessageBox::Yes | QMessageBox::No);
    if (reply == QMessageBox::Yes) {
        mvSettings.remove("");
    }
}

void Edit::on_pushButton_Close_clicked()
{
    mvSettings.sync();
    this->close();
}
