#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <QMainWindow>
#include <QList>
#include <QTime>
#include "common.h"

class QGraphicsScene;
class MickyMouse;
class Egg;
class Hen;
class QGraphicsItem;
class QTimer;
class QGraphicsTextItem;
class RemainingTrialItem;
class TextButton;
class HatchingEgg;

class GameWidget : public QMainWindow
{
    Q_OBJECT

public:
    explicit GameWidget(QWidget *parent = 0);

public slots:

    void newGame();

    void pauseGame();

    void resumeGame();

    void showMenu();

    void exitGame();

private slots:

    void keyReleased( QKeyEvent* event );

    void henTouched( Position position);

    void gameLoop();

    void eggAboutToFall();

    void eggHatched(HatchingEgg* hatchedEgg);

private:

    void createBase();

    void createHens();

    void createButtons();

    void createEgg();

    void increasePoints();

    void increaseDifficulty();

    void gameOver();

    void deleteOldScreen();

private:

    QGraphicsScene* mScene;
    MickyMouse* mMickyMouse;
    int mMaxEggCount;
    QList<Hen*> mHens;
    QList<Egg*> mEggs;
    QList<HatchingEgg*> mHatchingEggs;
    QList<QGraphicsItem*> mBases;
    QGraphicsTextItem* mScoreItem;
    RemainingTrialItem* mTrialItem;
    TextButton* mPauseBtn;
    QTimer* mGameTimer;    
    int mPoints;    
    int mMinSpeed;
    int mMaxSpeed;
    QGraphicsItem* mCurrentScreen;
    QTime mLastTimeEggDelivery;
};

#endif // GAMEWIDGET_H
