#ifndef BINARYDISPLAYWIDGET_H
#define BINARYDISPLAYWIDGET_H

#include <QBrush>
#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QSize>
#include <QWidget>

/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#define DEFAULT_LED_PEN_WIDTH 2

class BinaryDisplayWidget : public QWidget
{
    Q_OBJECT

public:
    explicit BinaryDisplayWidget(int bits, int value = 0, int widgetSize = 0, QWidget *parent = 0);

    virtual QSize sizeHint() = 0;

    virtual int getElementSize();

public slots:
    void applySettings();
    void updateValue(int value);

protected:
    int bits;

    int     ledBorder;
    QColor  ledColor;
    QPen    ledPen;
    int     ledSize;

    bool useGrayCode;

    int value;
    int widgetSize;

    virtual void draw(QPainter *painter) = 0;
    virtual void drawLed(int x, int y, bool on, QPainter *painter);

    void paintEvent(QPaintEvent *event);

    virtual void setLedSize(int size);
    virtual void setLedBorder(int border);

    virtual void setLedColor(const QColor &color);
    virtual void setLedPen(const QPen &pen);
};

#endif // BINARYDISPLAYWIDGET_H
