/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;

public class BeifahrerProgram : Hildon.Program {
	public const string BEIFAHRER_SERVICE = "org.maemo.beifahrer";

	QueryWindow window;
	public static Orientation orientation;

	construct {
		Environment.set_application_name ("Beifahrer");

		window = new QueryWindow ();
		window.destroy.connect (Gtk.main_quit);

		orientation = new Orientation ();
		orientation.changed.connect (on_orientation_changed);

		add_window (window);
	}

	private void on_orientation_changed () {
		if (orientation.portrait) {
			Hildon.gtk_window_set_portrait_flags (window, PortraitFlags.REQUEST);
		} else {
			Hildon.gtk_window_set_portrait_flags (window, PortraitFlags.SUPPORT);
		}
	}

	static int main (string[] args) {
		Gtk.init (ref args);

		Intl.setlocale (LocaleCategory.ALL, "");
		Intl.bindtextdomain (Config.GETTEXT_PACKAGE, Config.LOCALEDIR);
		Intl.textdomain (Config.GETTEXT_PACKAGE);

		var osso_context = new Osso.Context (BEIFAHRER_SERVICE, Config.VERSION, true, null);
		if (osso_context == null) {
			return Osso.Status.ERROR;
		}

		var app = new BeifahrerProgram ();

		Gtk.main ();

		return 0;
	}
}

