import gobject

import gtk
import hildon

import time

import beye

import dataprocessing

def dhmSince(since):
    if since == None:
        return '-'
    now = time.time()
    if since > now - 60:
        return '-'
    return dhm(now - since)

def dhm(timeDuration):
    if timeDuration == None or timeDuration < 60:
        return '-'
    m = int(timeDuration / 60)
    h = m / 60
    m = m % 60
    if (h >= 24):
        d = int(h / 24)
        h = h % 24
        if d == 1:
            days = 'day'
        else:
            days = 'days'
        return "%d %s, %d:%02d" % (d, days, h, m)
    else:
        return "%d:%02d" % (h, m)
   

class Statistics(hildon.StackableWindow):
    def __init__(self, dataStorage):
        hildon.StackableWindow.__init__(self)

        self.dataStorage = dataStorage

        self.connect("delete_event", self.onWindowClose)

        oldest = self.dataStorage.getOldestObservationTime()
        if oldest == None:
            oldest = 0
        self.set_title('Statistics, last %d days' % int((time.time() - oldest) / 86400))

        # Setting a label in the new window
        label = gtk.Label("Loading statistics...")
 
        vbox = gtk.VBox(False, 0)
        vbox.pack_start(label, True, True, 0)
        self.add(vbox)
 
        # This call show the window and also add the window to the stack
        hildon.hildon_gtk_window_set_progress_indicator(self, False)
        gobject.idle_add(self.showStatistics)
        self.show_all()

    def onWindowClose(self, param1, param2):
        hildon.hildon_gtk_window_set_progress_indicator(self, False)

    def showStatistics(self):
        now = time.time()
        chargeData = dataprocessing.getChargeInfo(self.dataStorage,
                                                  self.dataStorage.getOldestObservationTime(),
                                                  now, now)

        # Items shorter than this lenght (in seconds) will be discarded
        discardTreshold = 300

        # How large amount of data is considered for high and low discharge rates
        # 1 / highLowSelect
        # e.g. for highLowSelect = 4, the highest 1/4 of data is used for high rate,
        # and the lowest 1/4 for low rate
        highLowSelect = 3
        
        discharges = []
        charges = []

        for segment in chargeData:
            discharges.extend((i for i in segment if i[0] == (False, True) and i[2] - i[1] > discardTreshold))
            charges.extend((i for i in segment if i[0] == (True, False) and i[2] - i[1] > discardTreshold))

        chargeTime = 0
        dischargeTime = 0

        maxChargeTime = 0
        maxDischargeTime = 0

        for item in charges:
            chargeTime += item[2] - item[1]
            maxChargeTime = max(maxChargeTime, item[2] - item[1])

        for item in discharges:
            dischargeTime += item[2] - item[1]
            maxDischargeTime = max(maxDischargeTime, item[2] - item[1])

        try:
            avgChargeTime = int(chargeTime/len(charges))
        except ZeroDivisionError:
            avgChargeTime = None

        try:
            avgDischargeTime = int(dischargeTime/len(discharges))
        except ZeroDivisionError:
            avgDischargeTime = None

        try:
            lastChargeEnd = charges[-1][2]
        except IndexError:
            lastChargeEnd = None


        dischargeRates = []

        totalmAh = 0.0
        for dc in discharges:
            start = self.dataStorage.getNextObservedValueForType(dc[1], beye.DataSourceHal.CHARGE)
            end = self.dataStorage.getPreviousObservedValueForType(dc[2], beye.DataSourceHal.CHARGE)
            dischargeRates.append(((float(start-end) / (dc[2] - dc[1])), dc[2]-dc[1], start - end))
            totalmAh += start - end

        dischargeRates.sort(lambda x,y: cmp(y[0], x[0]))

        try:
            avgRate = totalmAh / dischargeTime
        except ZeroDivisionError:
            avgRate = 0.0

        if len(dischargeRates) == 0:
            highRate = 0.0
            lowRate = 0.0
        elif len(dischargeRates) < highLowSelect:
            highRate = avgRate
            lowRate = avgRate
        else:
            lowbound = len(dischargeRates) / highLowSelect
            highbound = (highLowSelect-1)*len(dischargeRates) / highLowSelect
            highrateTime = 0
            highmAh = 0.0
            for rates in dischargeRates[0:lowbound]:
                highrateTime += rates[1]
                highmAh += rates[2]
            highRate = float(highmAh) / highrateTime

            lowrateTime = 0
            lowmAh = 0.0
            for rates in dischargeRates[highbound:]:
                lowrateTime += rates[1]
                lowmAh += rates[2]
            lowRate = float(lowmAh) / lowrateTime

        maxCharge = self.dataStorage.getMaxCharge()
        if (maxCharge == None):
            maxCharge = 1300

        try:
            batteryLife = int(maxCharge / avgRate)
            batteryLowLife = int(maxCharge / lowRate)
            batteryHighLife = int(maxCharge / highRate)
        except ZeroDivisionError:
            batteryLife = None
            batteryLowLife = None
            batteryHighLife = None

        currentCharge = self.dataStorage.getPreviousObservedValueForType(now, beye.DataSourceHal.CHARGE)
        if currentCharge == None:
            currentCharge = 0
            
        try:
            batteryRemain = int(currentCharge / avgRate)
            batteryLowRemain = int(currentCharge / lowRate)
            batteryHighRemain = int(currentCharge / highRate)
        except ZeroDivisionError:
            batteryRemain = None
            batteryLowRemain = None
            batteryHighRemain = None

        parea = hildon.PannableArea()
        hbox = gtk.HBox(False, 0)
        vboxKeys = gtk.VBox(False, 0)
        vboxValues = gtk.VBox(False, 0)
        hbox.pack_start(gtk.VBox(False, 0))
        hbox.pack_start(vboxKeys)
        hbox.pack_start(vboxValues)
        for k, v in (('', ''),
                     ('Time since last charge', '%s' % dhmSince(lastChargeEnd)),
                     ('Number of charges (>%ds) recorded' % discardTreshold, '%d' % len(charges)),
                     ('Total charge time', '%s' % dhm(chargeTime)),
                     ('Average charge time', '%s' % dhm(avgChargeTime)),
                     ('Longest charge time', '%s' % dhm(maxChargeTime)),
                     ('', ''),
                     ('Number of discharges (>%ds) recorded' % discardTreshold, '%d' % len(discharges)),
                     ('Total discharge time', '%s' % dhm(dischargeTime)),
                     ('Average time between charges', '%s' % dhm(avgDischargeTime)),
                     ('Longest time between charges', '%s' % dhm(maxDischargeTime)),
                     ('Total ampere-hours discharged', '%.2f Ah' % (totalmAh / 1000)),
                     ('Discharge current (mAh/hour)', ''),
                     ('- Low use (lowest 1/%d of data)' % highLowSelect, '%.1f mA' % (lowRate * 3600)),
                     ('- Average use (all data)', '%.1f mA' % (avgRate * 3600)),
                     ('- High use (highest 1/%d of data)' % highLowSelect, '%.1f mA' % (highRate * 3600)),
                     ('', ''),
                     ('*Battery life for full charge (%d mAh)' % maxCharge, ''), 
                     ('- Low use', '%s' % dhm(batteryLowLife)), 
                     ('- Average use', '%s' % dhm(batteryLife)), 
                     ('- High use', '%s' % dhm(batteryHighLife)), 
                     ('*Battery life left now (%d mAh)' % currentCharge, ''),
                     ('- Low use', '%s' % dhm(batteryLowRemain)),
                     ('- Average use', '%s' % dhm(batteryRemain)),
                     ('- High use', '%s' % dhm(batteryHighRemain)),
                     ('', ''),
                     ('(*) Values are extrapolated from average, low and', ''),
                     ('      high discharge currents, accuracy may vary.', '')
                    ):
            label = gtk.Label(k)
            label.set_alignment(0, 0)
            vboxKeys.pack_start(label, False, False, 0)
 
            label = gtk.Label(v)
            label.set_alignment(0, 0)
            vboxValues.pack_start(label, False, False, 0)
           

        self.remove(self.get_children()[0])
        parea.add_with_viewport(hbox)
        self.add(parea)
        self.show_all()

        hildon.hildon_gtk_window_set_progress_indicator(self, False)
