class SliceSet(object):
    """ I like this class. """

    def __init__(self, slices=[]):
        self.slices = [(min(a), max(a)) for a in slices]

    def intersection(self, b):
        return [(max(a[0], b[0]), min(a[1], b[1]))
                for a in self.slices
                if max(a[0], b[0]) <= min(a[1], b[1])]

    def union(self, b):
        overlapping = [i
                       for i, a in zip(range(len(self.slices)), self.slices)
                       if max(a[0], b[0]-1) <= min(a[1], b[1]+1)]
        b = reduce(lambda x, y: (min(x[0], y[0]), max(x[1], y[1])),
                   (self.slices[i] for i in overlapping),
                   b)
        return [s
                for i, s in zip(range(len(self.slices) + 1), self.slices + [b])
                if i not in overlapping]

    def add(self, b):
        self.slices = self.union((min(b), max(b)))

    def subtract(self, b):
        try:
            ends = map(lambda f,x: f(x), (min, max), zip(*self.slices))
        except ValueError:
            # min and max throw ValueError when self.slices is empty
            return
        b = (min(b), max(b))
        if max(ends[0], b[0]) > min(ends[1], b[1]):
            # Ends and b don't intersect
            return
        if b[0] <= ends[0] and b[1] >= ends[1]:
            # The whole interval is being subtracted
            self.slices = []
            return
        if (b[0] > ends[0] and b[1] < ends[1]) \
           or (ends[0] > b[0] and ends[1] < b[1]):
            # We need to intersect with two slices
            s1 = map(lambda f,x: f(x), (min, max), ((ends[0], b[0]-1),)*2)
            s2 = map(lambda f,x: f(x), (min, max), ((b[1]+1, ends[1]),)*2)
            self.slices = self.intersection(s1) + self.intersection(s2)
        else:
            # Intersecting with one slice is enough. But we need to decide
            # whether to clip from left or right.
            clip = (max(ends[0], b[0]), min(ends[1], b[1]))
            # We know at this point that either clip[0] == ends[0] or clip[1] == ends[1]
            if clip[0] == ends[0]:
                trim = (clip[1] + 1, ends[1])
            else:
                trim = (ends[0], clip[0] - 1)
            self.slices = self.intersection(trim)
            
