#    This file is part of battery-eye.
#
#    battery-eye is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    battery-eye is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with battery-eye.  If not, see <http://www.gnu.org/licenses/>.

#    Copyright 2010 Jussi Holm

import os

import dbus

import time
import datetime

import gobject

from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

class Daemon(object):
    def __init__(self, dataStorage, dataSources):
        self.dataStorage = dataStorage
        self.dataSources = dataSources

    def run(self):
        print "battery-eye daemon\n"
        print "%s Start" % str(datetime.datetime.now())

        self.__updateValues(self.dataSources, 'startup', [], int(time.time()))

        bus = dbus.SystemBus()
        bus.add_signal_receiver(self.bmeSignalHandler, path='/org/freedesktop/Hal/devices/bme')
        gobject.timeout_add(1000 * 3600, self.periodicalHandler)
        print "Started."

        loop = gobject.MainLoop()
        try:
            loop.run()
        except KeyboardInterrupt:
            print "\nCtrl-C -> quit"
            loop.quit()
        
    def bmeSignalHandler(self, *args, **kwargs):
        print ""
        changes = []
        for change in args[1]:
            changes.append('hal.' + str(change[0]))
        print "%s Changed: %s" % (str(datetime.datetime.now()), ', '.join(changes))
        self.__updateValues(self.dataSources, 'periodical', changes, int(time.time()))

    def periodicalHandler(self):
        print ""
        print "%s Periodical update" % str(datetime.datetime.now())
        self.__updateValues(self.dataSources, 'periodical', [], int(time.time()))
        return True

    def __updateValues(self, dataSources, type, changes, now):
        for ds in dataSources:
            values = ds.read(type)
            for key, value in ds.decideStoreableValues(values, changes).items():
                print "%s -> %s" % (key, value)
                self.dataStorage.addObservation(key, value, now + ds.timestampAdjust(key), False)
                ds.markUpdated(key, value, now)
        self.dataStorage.con.commit()
       
