#!/bin/sh

pixmaps="/usr/share/pixmaps/*.png"
extras="/usr/share/icons/awoken-icon-theme/extras/*"
original="/home/user/.awoken-extras/orig/"

if [ "$(ls -A $original)" ]; then
	for bilder in $original
        do 
            bild=`basename ${bilder}`
            for ikon in ${pixmaps}
            do
                iko=`basename ${ikon}`

		if [ "${bild}" != "${iko}" ]; then                    	
                    	cp /usr/share/pixmaps/${iko} $original
		fi
            done
        done
else
	mkdir $original
	cp $pixmaps $original
fi	

if [ "$(ls -A /opt/multical-date-widget/)" ]; then
	if [ "$(ls -A /home/user/.awoken-extras/orig/calendar.png)" ]; then
		echo ""
	else 
		cp /opt/multical-date-widget/calendar.png $original
	fi
fi

if [ "$(ls -A /opt/tomch.com/)" ]; then
	if [ "$(ls -A /home/user/.awoken-extras/orig/tomch.com/)" ]; then
		echo ""
	else 
		cp -r /opt/tomch.com/ $original
	fi
fi

case "$1" in
    '-'[Cc] | '--change')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	cp ${img} /usr/share/pixmaps/
                    	echo ""
                    fi
                    
            done
        done
        cp /usr/share/icons/awoken-icon-theme/extras/calendar-5.png /opt/multical-date-widget/calendar.png
        cp /usr/share/icons/awoken-icon-theme/extras/recaller/* /opt/tomch.com/recaller/
    exit
    ;;
    '-'[Bb] | '--backup')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	rm ${pics}.orig
                    	cp ${pics} ${pics}.orig
                    	echo ""
                    fi
                    
            done
        done
	rm /opt/multical-date-widget/calendar.png.orig
	rm /opt/tomch.com/recaller/*.orig
	cp /opt/multical-date-widget/calendar.png /opt/multical-date-widget/calendar.png.orig
	cp /opt/tomch.com/recaller/recaller_64.png /opt/tomch.com/recaller/recaller_64.png.orig
	cp /opt/tomch.com/recaller/recaller_64_on.png /opt/tomch.com/recaller/recaller_64_on.png.orig
    exit
    ;;
    '-'[Rr] | '--reset')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	mv ${pics}.orig ${pics}
                    	echo ""
                    fi
                    
            done
        done
	mv /opt/multical-date-widget/calendar.png.orig /opt/multical-date-widget/calendar.png
	mv /opt/tomch.com/recaller/recaller_64.png.orig /opt/tomch.com/recaller/recaller_64.png
	mv /opt/tomch.com/recaller/recaller_64_on.png.orig /opt/tomch.com/recaller/recaller_64_on.png
    exit
    ;;
esac
