﻿#!/usr/bin/env python

import sys, os, re
from PyQt4 import QtGui
from PyQt4 import QtCore
 
class TextEditor(QtGui.QMainWindow):    
 
    def __init__(self, parent=None):
        self.confDir = "/home/user/.AutoFreeWifi"
        if not os.path.exists(self.confDir):
           os.makedirs(self.confDir)

        QtGui.QMainWindow.__init__(self, parent)
        self.setWindowTitle('AutoFreeWifi Configuration')
        
        hHelpLayout = QtGui.QHBoxLayout()
        help = QtGui.QLabel()
        help.setText(u"AutoFreeWifi a besoin de vos identifiants FreeWifi.\n\
Si vous ne les avez pas, rendez-vous sur http://wifi.free.fr/ depuis \n\
votre Freebox.\n\
Une fois configuré, vous n'avez plus rien à faire, AutoFreeWifi procèdera \n\
à l'authentification automatiquement quand vous vous connecterez \n\
à un réseau FreeWifi.")
        hHelpLayout.addWidget(help)
        
        hLayout = QtGui.QHBoxLayout()
        self.labelid = QtGui.QLabel()
        self.labelid.setText("Identifiant")
        self.login = QtGui.QLineEdit()
        hLayout.addWidget(self.labelid)
        hLayout.addWidget(self.login)
        
        hLayout2 = QtGui.QHBoxLayout()
        self.labelpwd = QtGui.QLabel()
        self.labelpwd.setText("Mot de passe")
        self.password = QtGui.QLineEdit()
        self.password.setEchoMode(QtGui.QLineEdit.Password)
        hLayout2.addWidget(self.labelpwd)
        hLayout2.addWidget(self.password)

        login, password = self.readConfig()
        self.login.setText(login)
        self.password.setText(password)

        hLayout3 = QtGui.QHBoxLayout()
        
        buttonOK = QtGui.QPushButton("Valider")
        buttonCancel = QtGui.QPushButton("Annuler")
        
        hLayout3.addWidget(buttonOK)
        hLayout3.addWidget(buttonCancel)

        vLayout = QtGui.QVBoxLayout()
        vLayout.addLayout(hHelpLayout)
        vLayout.addLayout(hLayout)
        vLayout.addLayout(hLayout2)
        vLayout.addLayout(hLayout3)
 
        self.mainframe = QtGui.QFrame()
        self.mainframe.setLayout(vLayout)
        self.setCentralWidget(self.mainframe)

        QtCore.QObject.connect(buttonOK, QtCore.SIGNAL("clicked()"), self.accept)
        QtCore.QObject.connect(buttonCancel, QtCore.SIGNAL("clicked()"), self.reject)
        
    def accept(self):
        login = self.login.text()
        password = self.password.text()
        self.saveConfig(login, password)
        
        self.close()

    def reject(self):
        self.close()
        
    def readConfig(self):
        confFile = os.path.join(self.confDir, "login.conf")
        login = ""
        password = ""

        if os.path.exists(confFile):
           f = open( confFile, "r")

           line = f.readline()
           res = re.search('LOGIN="(.+)"', line)
           if res:
              login = res.group(1)
                     
           line = f.readline()
           res = re.search('PASSWORD="(.+)"', line)
           if res:
              password = res.group(1)

           f.close()
        
        return login, password

    def saveConfig(self, login, password):
        f = open( os.path.join(self.confDir, "login.conf"), "w")
        f.write("LOGIN=\""+login+"\"\n")
        f.write("PASSWORD=\""+password+"\"\n")
        f.close()

        
if __name__ == '__main__':    

    #Creating Qt application
    app = QtGui.QApplication(sys.argv)
 
    myTextEditor = TextEditor()
    myTextEditor.show()
 
    #Initing application
    sys.exit(app.exec_())
