#include "control.h"

#include <QFileInfo>
#include <QStringList>
#include <QFileDialog>
#include <QStackedLayout>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QSettings>
#include <QCoreApplication>
#include <QTimer>

#include "booklistwidget.h"
#include "readwidget.h"
#include "audiobook.h"

Control::Control( QWidget* aParent )
    :QMainWindow(aParent),mBookListModel(0),mBookListWidget( 0 ),mReadWidget(0)
{
//    mWidget = new QWidget();
//    mWidget->setWindowTitle("Audiobook Reader");
//
//    mBookListModel = new QStandardItemModel( mWidget );
//    mBookListWidget = new BookListWidget( mBookListModel ,mWidget );
//    mBookListWidget->setProperty("FingerScrollable", true);
//    mReadWidget = new ReadWidget(mWidget);
//    mReadWidget->setAttribute(Qt::WA_Maemo5StackedWindow);
//
//    mStackLayout =  new QStackedLayout(mWidget);
//    mStackLayout->addWidget(mBookListWidget);
//    mStackLayout->addWidget(mReadWidget);
//    mStackLayout->setCurrentWidget(mBookListWidget);
//
//    mWidget->show();
//
//    connect(mBookListWidget,SIGNAL(addNewBook()),this,SLOT(addBooks()));
//    connect(mBookListWidget,SIGNAL(createNewBook()),this,SLOT(createNewBook()));
//    connect(mBookListWidget,SIGNAL(readBook(int)),this,SLOT(readBook(int)));
//    connect(mBookListWidget,SIGNAL(removeBook(int)),this,SLOT(removeBook(int)));
//    connect(mReadWidget,SIGNAL(backClicked()),this,SLOT(back()));
//
//    QTimer::singleShot( 500,this,SLOT(loadBookList()));

    mBookListModel = new QStandardItemModel();
    mBookListWidget = new BookListWidget( mBookListModel,this);
    mReadWidget = new ReadWidget(mBookListWidget);

#ifdef Q_WS_MAEMO_5
    mBookListWidget->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    mBookListWidget->setWindowFlags(mBookListWidget->windowFlags() | Qt::Window);
    mBookListWidget->setProperty("FingerScrollable", true);
    mBookListWidget->setWindowTitle("Audiobook Reader");

#ifdef Q_WS_MAEMO_5
    mReadWidget->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    mReadWidget->setWindowFlags(mReadWidget->windowFlags() | Qt::Window);
    mReadWidget->setWindowTitle("Audiobook Reader");

    connect(mReadWidget,SIGNAL(bookClosed(AudioBook*)),this,SLOT(bookClosed(AudioBook*)));
    connect(mReadWidget,SIGNAL(bookPaused(AudioBook*)),this,SLOT(bookPaused(AudioBook*)));

    connect(mBookListWidget,SIGNAL(addNewBook()),this,SLOT(addBooks()));
    connect(mBookListWidget,SIGNAL(createNewBook()),this,SLOT(createNewBook()));
    connect(mBookListWidget,SIGNAL(readBook(int)),this,SLOT(readBook(int)));
    connect(mBookListWidget,SIGNAL(removeBook(int)),this,SLOT(removeBook(int)));

   this->setCentralWidget( mBookListWidget );
   mBookListWidget->show();
    QTimer::singleShot( 0,this,SLOT(loadBookList()));
}

Control::~Control()
{
    storeBookList();
    delete mBookListModel;
    //delete mBookListWidget;
}

void Control::addBooks()
{
    QStringList files = QFileDialog::getOpenFileNames(
                         0,
                         tr("Select Audio file which has all chapter inside."),
                         "/$HOME");

    for (int i=0 ; i < files.count() ; ++i)
    {
        QFileInfo file(files[i]);
        if( !isBookAdded(file.fileName()))
        {
            AudioBook* book = new AudioBook( file.fileName() );
            QStringList list;
            list << file.absoluteFilePath();
            book->setSource( list );
            mBookListModel->appendRow(book);
        }
    }
}

void Control::createNewBook()
{
    QString dirStr = QFileDialog::getExistingDirectory(0, tr("Select Folder which has audio file for invidual chapter inside"),
                                                 "/$HOME",
                                                 QFileDialog::ShowDirsOnly
                                                 | QFileDialog::DontResolveSymlinks );
    QDir dir(dirStr);
    if( isBookAdded( dir.dirName() )) {
        return;
    }

    AudioBook* book = new AudioBook( dir.dirName() );
    QFileInfoList infoList = dir.entryInfoList();
    QStringList sourceList;
    for( int i =0 ;i < infoList.count() ;++i) {
        if( infoList[i].isFile() ) {
            sourceList << infoList[i].absoluteFilePath();
        }
    }
    book->setSource(sourceList);
    mBookListModel->appendRow(book);
}

void Control::loadBookList()
{
    qDebug() << "loading book list";
    QSettings settings("kunal","audiobookreader");
    QStringList keys  = settings.allKeys();
    for( int i = 0 ; i < keys.count() ; ++i ) {
        AudioBook* book = new AudioBook(settings.value(keys[i]));
        mBookListModel->appendRow(book);
    }
}

void Control::storeBookList()
{   
    qDebug() << "Storing book list";
    QSettings settings("kunal","audiobookreader");
    settings.clear();
    for(int i =0 ; i < mBookListModel->rowCount() ; ++i ) {
        AudioBook* book = static_cast<AudioBook*>( mBookListModel->item(i));
        settings.setValue(book->bookName(),book->toVariant());
    }
}

bool Control::isBookAdded( const QString& aBookName )
{
    QSettings settings("kunal","audiobookreader");
    return settings.value(aBookName).isValid();
}

void Control::readBook(int aIndex)
{
    qDebug() << "reading book";
    AudioBook* book  = static_cast<AudioBook*> ( mBookListModel->item(aIndex) );
    mReadWidget->readBook(book);
    mReadWidget->show();
}

void Control::removeBook(int aIndex)
{
    mReadWidget->readBook(0);
    mBookListModel->removeRow(aIndex);
}

void Control::bookClosed(AudioBook* book)
{
    qDebug() << "book closed" << book->progress();
    QSettings settings("kunal","audiobookreader");
    settings.setValue( book->bookName(), book->toVariant() );
    mBookListModel->setItem(book->row(), new AudioBook( book->toVariant() ));
}

void Control::bookPaused(AudioBook* book)
{
    qDebug() << "book paused" << book->progress();
    QSettings settings("kunal","audiobookreader");
    settings.setValue( book->bookName(), book->toVariant() );
    //mBookListModel.setItem(book->row(), new AudioBook( book->toVariant() ));
}
