#include "commentingwidget.h"
#include "ui_commentingwidget.h"
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

CommentingWidget::CommentingWidget(MaemoApplicationHandler *handler,QString appName, int w, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::CommentingWidget)
{
    ui->setupUi(this);
    applicationHandler = handler;
    applicationName = appName;
    id =w;
    ratingLabel = new RatingLabel (0,ui->ratingFrame,true);
    ratingLabel->setGeometry(200,0,600,54);
    ratingLabel->show();
}

CommentingWidget::~CommentingWidget()
{
    delete ui;
    delete ratingLabel;
}

void CommentingWidget::sendComment() {
    if (ratingLabel->rating()==0) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nPlease rate the application before sending!\n");
        #endif
    }
    else {
        qDebug()<<"comment with rating: " + QString::number(ratingLabel->rating());
        qDebug()<<"Text: " + ui->commentingTextEdit->toPlainText();
        qDebug()<<"Application: "+applicationName;
        ui->sendButton->setEnabled(false);
        applicationHandler->commentApplication (ratingLabel->rating(),ui->commentingTextEdit->toPlainText(),applicationName);
        connect (applicationHandler,SIGNAL(commented(int)),this,SLOT(commentResponse(int)));
    }
}

void CommentingWidget::commentResponse (int res) {
    disconnect (applicationHandler,SIGNAL(commented(int)),this,SLOT(commentResponse(int)));
    if (res == MaemoApplicationHandler::CommentSuccess) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(parentWidget(),"\nComment was sent successfully\n");
        #endif
        emit deleteWidget(id);
    }
    else {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nConnection problem, please try to resend!\n");
        #endif
        ui->sendButton->setEnabled(true);
    }

}

void CommentingWidget::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CommentingWidget::closeWidget() {
    this->close();
    emit deleteWidget(id);
}
