# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import os.path
import time

from PIL import Image

from filters.display import *
from filters.imageExif import *
from filters.rotate import *
from filters.toolbox import *


def FileOpenReleased(self):
    """
    Key Press to launch File open dialog, store image and display on GUI
    """
    ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
    if ImgTemp != "":
        SwitchDisplayAndLoadFile(self, ImgTemp)


def SwitchDisplayAndLoadFile(self,  filename):
    ShowApply(self, False)
    ToggleThumbWait(self, True)
    FullScreenToggle(self, False)
    FileImageOpen(self,  filename)
    self.core.SetCurrentTab(2)
    self.tabStrip.setCurrentIndex(2)
    PhotTabs_Show(self)
    ToggleThumbWait(self, False)
    self.repaint()
    self.core.SomethingLoad =True


def FileImageOpen(self,  filename):
    """
    Open File and poulate class parameters of Image.
    """
    try:
        
        self.repaint()
        del self.core.undoList_IM[:]
        self.core.curImageLoc = filename
        self.core.current.image = Image.open(self.core.curImageLoc)
        ##Clear UndoStates
        self.core.UndoImage_Clear()
        ##Standard Load and refresh Image
        FileImageRefresh(self)
        
    except:
        print "Error: FileImageOpen:"+filename
        
    return

def FileImageRefresh(self):
    
    #tim=time.time()
    FileImageLoadSizes(self)
    self.core.UndoImage_Push()
    FileImageDisplayRefresh(self)
    #print("Image Reload Time: "+str(time.time()-tim))
    
def FileImageLoadSizes(self):
    try:

        self.core.valOrient= GetExifRotation(self, self.core.curImageLoc)
        im=rotateImage(self, self.core.current.image,  self.core.valOrient)
        ##These 2 take 1.5 seconds which is acceptable.
        w, h = im.size
        wTh,  hTh = convertImSize(self.core, w, h,  300,  180, self.core.valOrient,  1)
        size = (wTh,  hTh )
        
        #self.core.current.thumb = im.resize(size, Image.NEAREST) ##This takes 0.015 Seconds!!!!!
        #self.core.current.thumb = im.resize(size, Image.BILINEAR) ##This takes 0.30 Seconds!!!!!
        #self.core.current.thumb = im.resize(size, Image.ANTIALIAS) ##This takes 10.5 Seconds!!!!!
        #self.core.current.thumb = im.resize(size, Image.BICUBIC) ##This takes 0.6 Seconds!!!!!
        self.core.current.thumb = im.resize(size, Image.BILINEAR) ##This takes 0.30 Seconds!!!!!


        self.core.current.setThumbDisplaySize(170-int(wTh/2), 200-int(hTh/2), wTh, hTh)
        w, h = self.core.current.image.size
        wTh,  hTh = convertImSize(self.core,  w, h,  796,  430)
        
        self.core.current.setImageDisplaySize(398-int(wTh/2), 216-int(hTh/2), wTh, hTh)

        self.core.EXIFLoaded = False
    except:
        print "FileLoadImage Error"

def FileImageDisplayRefresh(self):
    try:
        tim=time.time()
        #ToggleThumbWait(self, True)

        self.photo.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.photo_Thumb.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.photo_Thumb.setPixmap(pil2qpixmap(self.core.current.thumb))
        ##strangly takes only 0.01s to load??
        
        #tim=time.time()
        self.photo.setPixmap(pil2qpixmap(self.core.current.image))
        ##1.25 second load. ergggh
        #print("Reload Main Image: "+str(time.time()-tim))
        
        self.photo.setGeometry(self.core.current.getImageDisplaySize())
        self.photo_Thumb.setGeometry(self.core.current.getThumbDisplaySize())
        self.btnFullScreen.setGeometry(self.core.current.getThumbDisplaySize())
        
        #ToggleThumbWait(self, False)
    except:
        return
        
def StripFilename(self,  myPath):
    (dirName, fileName) = os.path.split(myPath)
    (fileBaseName, fileExtension)=os.path.splitext(fileName)
    return (dirName, fileBaseName, fileExtension)

def MostRecentImage(self):
    files =[]
    for file in os.listdir(self.core.imageDir):
        files.append(file)


#######################################
#   Save As
#######################################
def DisplaySaveAs(self):
    fileLoc=StripFilename(self, self.core.curImageLoc)
    i = str(self.btnSaveAsGenFilename(fileLoc[0], fileLoc[1]))
    self.btnSaveAs_Filename.setText(fileLoc[1]+"_"+i)
    self.btnSaveAs_Location.setText(fileLoc[0])
    self.titlePop_Name_3.setText(fileLoc[0]+"/"+fileLoc[1]+"_"+i+"."+str(self.btnSaveAs_Combo.currentText()).replace("JPEG", "jpg"))
    self.frameSaveAuto.setVisible(True)
    self.frameSaveAvd.setVisible(False)
    self.frameSaveAs.setGeometry(0, 40, 800, 480)
