/*
 * Copyright (c) 2010 Kaj-Michael Lang
 * 
 * Draw given QRCode on cairo surfce.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _QRCODE_EXPORT_H
#define _QRCODE_EXPORT_H

#include <glib.h>
#include <qrencode.h>
#include <cairo.h>

cairo_surface_t *gqre_qrcode_to_cairo(QRcode *q, gint isize, gdouble padding);
cairo_surface_t *gqre_char_to_qrcode_to_cairo(const gchar *str, gint smin, gint smax, gint padding);

#endif
