/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SGTK_FIND_DIALOG_H
#define _SGTK_FIND_DIALOG_H

#include "sgtk-dialog.h"

#define SGTK_TYPE_FIND_DIALOG			(sgtk_find_dialog_get_type())
#define SGTK_FIND_DIALOG(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), SGTK_TYPE_FIND_DIALOG, sGtkFindDialog))
#define SGTK_FIND_DIALOG_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), SGTK_TYPE_FIND_DIALOG, sGtkFindDialogClass))
#define SGTK_IS_FIND_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), SGTK_TYPE_FIND_DIALOG))
#define SGTK_IS_FIND_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), SGTK_TYPE_FIND_DIALOG))
#define SGTK_FIND_DIALOG_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), SGTK_TYPE_FIND_DIALOG, sGtkFindDialogClass))

typedef struct _sGtkFindDialogPrivate sGtkFindDialogPrivate;

typedef struct
{
  sGtkDialog			dialog;

  sGtkFindDialogPrivate		*priv;
} sGtkFindDialog;

typedef struct
{
  sGtkDialogClass		parent_class;
} sGtkFindDialogClass;

GType		sgtk_find_dialog_get_type           (void);
GtkWidget	*sgtk_find_dialog_new               (GtkWindow      *parent);
void		sgtk_find_dialog_set_token          (sGtkFindDialog *dialog,
						     const char     *token);
const char	*sgtk_find_dialog_get_token         (sGtkFindDialog *dialog);
void		sgtk_find_dialog_set_history        (sGtkFindDialog *dialog,
						     GSList         *history);
GSList		*sgtk_find_dialog_get_history       (sGtkFindDialog *dialog);
void		sgtk_find_dialog_set_case_sensitive (sGtkFindDialog *dialog,
						     gboolean       case_sensitive);
gboolean	sgtk_find_dialog_get_case_sensitive (sGtkFindDialog *dialog);
void		sgtk_find_dialog_set_wrap_around    (sGtkFindDialog *dialog,
						     gboolean       wrap_around);
gboolean	sgtk_find_dialog_get_wrap_around    (sGtkFindDialog *dialog);
void		sgtk_find_dialog_set_previous_sensitive (sGtkFindDialog	*dialog,
							 gboolean	sensitive);
void		sgtk_find_dialog_set_next_sensitive	(sGtkFindDialog	*dialog,
							 gboolean	sensitive);

#endif /* _SGTK_FIND_DIALOG_H */
